/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.network;

import me.jaackson.etched.common.entity.MinecartJukebox;
import me.jaackson.etched.common.network.EtchedPacket;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientboundPlayMinecartJukeboxMusicPacket
implements EtchedPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("etched", "play_minecart_jukebox_music");
    private final Action action;
    private final int recordId;
    private final ITextComponent title;
    private final String url;
    private final int entityId;

    public ClientboundPlayMinecartJukeboxMusicPacket(ITextComponent title, String url, MinecartJukebox entity, boolean restart) {
        this.action = restart ? Action.RESTART : Action.START;
        this.recordId = 0;
        this.title = title;
        this.url = url;
        this.entityId = entity.func_145782_y();
    }

    public ClientboundPlayMinecartJukeboxMusicPacket(MusicDiscItem recordItem, MinecartJukebox entity, boolean restart) {
        this.action = restart ? Action.RESTART : Action.START;
        this.recordId = Registry.field_212630_s.func_148757_b((Object)recordItem);
        this.title = null;
        this.url = null;
        this.entityId = entity.func_145782_y();
    }

    public ClientboundPlayMinecartJukeboxMusicPacket(MinecartJukebox entity) {
        this.action = Action.STOP;
        this.recordId = 0;
        this.title = null;
        this.url = null;
        this.entityId = entity.func_145782_y();
    }

    public ClientboundPlayMinecartJukeboxMusicPacket(PacketBuffer buf) {
        this.action = (Action)buf.func_179257_a(Action.class);
        this.recordId = this.action == Action.STOP ? 0 : buf.func_150792_a();
        this.title = this.action == Action.STOP || this.recordId != 0 ? null : buf.func_179258_d();
        this.url = this.action == Action.STOP || this.recordId != 0 ? null : buf.func_218666_n();
        this.entityId = buf.func_150792_a();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.action);
        if (this.action != Action.STOP) {
            buf.func_150787_b(this.recordId);
            if (this.recordId == 0) {
                buf.func_179256_a(this.title);
                buf.func_180714_a(this.url);
            }
        }
        buf.func_150787_b(this.entityId);
    }

    @Override
    public ResourceLocation getChannel() {
        return CHANNEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Action getAction() {
        return this.action;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecordId() {
        return this.recordId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getTitle() {
        return this.title;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getUrl() {
        return this.url;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    public static enum Action {
        START,
        STOP,
        RESTART;

    }
}

