/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.datagen;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import me.jaackson.etched.EtchedRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ModelTextures;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.ModelsUtil;
import net.minecraft.data.StockModelShapes;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemModelGen
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer;

    public ItemModelGen(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    private static Path createModelPath(Path dataFolder, ResourceLocation name) {
        return dataFolder.resolve("assets/" + name.func_110624_b() + "/models/" + name.func_110623_a() + ".json");
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        HashMap map1 = Maps.newHashMap();
        this.consumer = (location, json) -> {
            Supplier supplier = map1.put(location, json);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + location);
            }
        };
        this.register();
        this.saveCollection(cache, path, map1, ItemModelGen::createModelPath);
    }

    private void register() {
        this.generateFlatItem(EtchedRegistry.BLANK_MUSIC_DISC.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem(EtchedRegistry.MUSIC_LABEL.get(), StockModelShapes.field_240273_aK_);
        this.generateFlatItem(EtchedRegistry.JUKEBOX_MINECART.get(), StockModelShapes.field_240273_aK_);
    }

    private void generateFlatItem(Item item, ModelsUtil p_240076_2_) {
        p_240076_2_.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)item), ModelTextures.func_240352_b_((Item)item), this.consumer);
    }

    private void generateFlatItem(Item item, String p_240077_2_, ModelsUtil p_240077_3_) {
        p_240077_3_.func_240234_a_(ModelsResourceUtil.func_240220_a_((Item)item, (String)p_240077_2_), ModelTextures.func_240376_j_((ResourceLocation)ModelTextures.func_240344_a_((Item)item, (String)p_240077_2_)), this.consumer);
    }

    private void generateFlatItem(Item item, Item p_240075_2_, ModelsUtil p_240075_3_) {
        p_240075_3_.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)item), ModelTextures.func_240352_b_((Item)p_240075_2_), this.consumer);
    }

    private <T> void saveCollection(DirectoryCache cache, Path dataFolder, Map<T, ? extends Supplier<JsonElement>> models, BiFunction<Path, T, Path> resolver) {
        models.forEach((p_240088_3_, p_240088_4_) -> {
            Path path = (Path)resolver.apply(dataFolder, p_240088_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)p_240088_4_.get()), (Path)path);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        });
    }

    public String func_200397_b() {
        return "etched Block State Definitions";
    }
}

