/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.forge;

import me.jaackson.etched.Etched;
import me.jaackson.etched.datagen.ItemModelGen;
import me.jaackson.etched.datagen.ItemTagGen;
import me.jaackson.etched.datagen.LanguageGen;
import me.jaackson.etched.datagen.LootTableGen;
import me.jaackson.etched.datagen.RecipeGen;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="etched")
public class EtchedForge {
    public EtchedForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::clientSetup);
        Etched.commonInit();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Etched::clientInit);
        Etched.commonNetworkingInit();
        Etched.clientNetworkingInit();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Etched::commonPostInit);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(Etched::clientPostInit);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        dataGenerator.func_200390_a((IDataProvider)new RecipeGen(dataGenerator));
        dataGenerator.func_200390_a((IDataProvider)new LootTableGen(dataGenerator));
        dataGenerator.func_200390_a((IDataProvider)new ItemModelGen(dataGenerator));
        dataGenerator.func_200390_a((IDataProvider)new ItemTagGen(dataGenerator, new BlockTagsProvider(dataGenerator, "etched", existingFileHelper), existingFileHelper));
        dataGenerator.func_200390_a((IDataProvider)new LanguageGen(dataGenerator));
    }
}

