/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class TrackData {
    public static final TrackData EMPTY = new TrackData(null, "Unknown", (class_2561)new class_2585("Custom Music"));
    public static final Codec<TrackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Url").forGetter(TrackData::getUrl), (App)Codec.STRING.optionalFieldOf("Author", (Object)EMPTY.getArtist()).forGetter(TrackData::getArtist), (App)Codec.STRING.optionalFieldOf("Title", (Object)class_2561.class_2562.method_10867((class_2561)EMPTY.getTitle())).xmap(json -> {
        if (!json.startsWith("{")) {
            return new class_2585(json);
        }
        try {
            return class_2561.class_2562.method_10877((String)json);
        }
        catch (JsonParseException e) {
            return new class_2585(json);
        }
    }, class_2561.class_2562::method_10867).forGetter(TrackData::getTitle)).apply((Applicative)instance, TrackData::new));
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");
    private final String url;
    private final String artist;
    private final class_2561 title;

    public TrackData(String url, String artist, class_2561 title) {
        this.url = url;
        this.artist = artist;
        this.title = title;
    }

    public static boolean isValid(class_2487 nbt) {
        return nbt.method_10573("Url", 8) && TrackData.isValidURL(nbt.method_10558("Url"));
    }

    public static boolean isValidURL(@Nullable String url) {
        if (url == null) {
            return false;
        }
        if (TrackData.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(@Nullable String url) {
        if (url == null) {
            return false;
        }
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public class_2487 save(class_2487 nbt) {
        if (this.url != null) {
            nbt.method_10582("Url", this.url);
        }
        if (this.title != null) {
            nbt.method_10582("Title", class_2561.class_2562.method_10867((class_2561)this.title));
        }
        if (this.artist != null) {
            nbt.method_10582("Author", this.artist);
        }
        return nbt;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArtist() {
        return this.artist;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public TrackData withUrl(String url) {
        return new TrackData(url, this.artist, this.title);
    }

    public TrackData withArtist(String artist) {
        return new TrackData(this.url, artist, this.title);
    }

    public TrackData withTitle(String title) {
        return new TrackData(this.url, this.artist, (class_2561)new class_2585(title));
    }

    public TrackData withTitle(class_2561 title) {
        return new TrackData(this.url, this.artist, title);
    }

    public class_2561 getDisplayName() {
        return new class_2588("sound_source.etched.info", new Object[]{this.artist, this.title});
    }
}

