/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.download;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.source.RawAudioSource;
import gg.moonflower.etched.api.sound.source.StreamingAudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.client.render.item.AlbumTextureCache;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3300;
import net.minecraft.class_3521;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class SoundSourceManager {
    private static final Set<SoundDownloadSource> SOURCES = new HashSet<SoundDownloadSource>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileCache ALBUM_COVER_CACHE = new AlbumTextureCache((Executor)class_3521.field_15664, 1L, TimeUnit.DAYS);

    private SoundSourceManager() {
    }

    public static synchronized void registerSource(SoundDownloadSource source) {
        SOURCES.add(source);
    }

    public static CompletableFuture<AudioSource> getAudioSource(String url, @Nullable DownloadProgressListener listener, Proxy proxy, AudioSource.AudioFileType type) throws MalformedURLException {
        Optional<SoundDownloadSource> source = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst();
        return (source.isPresent() ? CompletableFuture.supplyAsync(() -> {
            try {
                return ((SoundDownloadSource)source.get()).resolveUrl(url, listener, proxy).toArray(new URL[0]);
            }
            catch (Exception e) {
                throw new CompletionException("Failed to connect to " + ((SoundDownloadSource)source.get()).getApiName() + " API", e);
            }
        }, (Executor)class_3521.field_15664) : CompletableFuture.completedFuture(new URL[]{new URL(url)})).thenApplyAsync(urls -> {
            try {
                if (((URL[])urls).length == 0) {
                    throw new IOException("No audio data was found at the source!");
                }
                if (((URL[])urls).length == 1) {
                    return new RawAudioSource(DigestUtils.sha1Hex((String)url), urls[0], listener, source.map(s -> s.isTemporary(url)).orElse(false), type);
                }
                return new StreamingAudioSource(DigestUtils.sha1Hex((String)url), (URL[])urls, listener, source.map(s -> s.isTemporary(url)).orElse(false), type);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)class_3521.field_15664);
    }

    public static CompletableFuture<TrackData[]> resolveTracks(String url, @Nullable DownloadProgressListener listener, Proxy proxy) throws IOException {
        SoundDownloadSource source = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst().orElseThrow(() -> new IOException("Unknown source for: " + url));
        return CompletableFuture.supplyAsync(() -> {
            try {
                return source.resolveTracks(url, listener, proxy);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)class_3521.field_15664);
    }

    public static CompletableFuture<AlbumCover> resolveAlbumCover(String url, @Nullable DownloadProgressListener listener, Proxy proxy, class_3300 resourceManager) {
        return CompletableFuture.supplyAsync(() -> SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst().flatMap(source -> {
            try {
                return source.resolveAlbumCover(url, listener, proxy, resourceManager);
            }
            catch (Exception e) {
                LOGGER.error("Failed to connect to " + source.getApiName() + " API", (Throwable)e);
                return Optional.empty();
            }
        }), (Executor)class_3521.field_15664).thenCompose(coverUrl -> coverUrl.map(s -> ALBUM_COVER_CACHE.requestResource(s, false).thenApplyAsync(path -> {
            AlbumCover albumCover;
            block8: {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    albumCover = AlbumCover.of(class_1011.method_4309((InputStream)is));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new CompletionException("Failed to read album cover from '" + url + "'", e);
                    }
                }
                is.close();
            }
            return albumCover;
        }, (Executor)class_156.method_27958())).orElseGet(() -> CompletableFuture.completedFuture(AlbumCover.EMPTY)));
    }

    public static Optional<class_2561> getBrandText(String url) {
        return SOURCES.stream().filter(source -> source.isValidUrl(url)).findFirst().flatMap(s -> s.getBrandText(url));
    }

    public static boolean isValidUrl(String url) {
        return SOURCES.stream().anyMatch(s -> s.isValidUrl(url));
    }
}

