/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.client.render.item.ImageAlbumCover;
import gg.moonflower.etched.client.render.item.ModelAlbumCover;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.apache.commons.codec.digest.DigestUtils;

public class AlbumCoverItemRenderer
extends class_4080<CoverData>
implements DynamicItemRenderer,
PollinatedPreparableReloadListener {
    public static final AlbumCoverItemRenderer INSTANCE = new AlbumCoverItemRenderer();
    public static final String FOLDER_NAME = "etched_album_cover";
    private static final class_1091 BLANK_ALBUM_COVER = new class_1091(new class_2960("etched", "etched_album_cover/blank"), "inventory");
    private static final class_1091 DEFAULT_ALBUM_COVER = new class_1091(new class_2960("etched", "etched_album_cover/default"), "inventory");
    private static final class_2960 ALBUM_COVER_OVERLAY = new class_2960("etched", "textures/item/album_cover_overlay.png");
    private static final class_801 ITEM_MODEL_GENERATOR = new class_801();
    private static final class_793 MODEL = class_793.method_3430((String)"{\"gui_light\":\"front\",\"textures\":{\"layer0\":\"texture\"},\"display\":{\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,2,0],\"scale\":[0.5,0.5,0.5]},\"head\":{\"rotation\":[0,180,0],\"translation\":[0,13,7],\"scale\":[1,1,1]},\"thirdperson_righthand\":{\"rotation\":[0,0,0],\"translation\":[0,3,1],\"scale\":[0.55,0.55,0.55]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[0.68,0.68,0.68]},\"fixed\":{\"rotation\":[0,180,0],\"scale\":[1,1,1]}}}");
    private final Map<class_2487, CompletableFuture<ModelData>> covers = new HashMap<class_2487, CompletableFuture<ModelData>>();
    private CoverData data = null;

    private AlbumCoverItemRenderer() {
    }

    public static void init() {
        ResourceRegistry.registerReloadListener((class_3264)class_3264.field_14188, (PollinatedPreparableReloadListener)INSTANCE);
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> INSTANCE.close());
    }

    public static class_1011 getOverlayImage() {
        return AlbumCoverItemRenderer.INSTANCE.data.overlay.getImage();
    }

    private static void renderModelLists(class_1087 model, int combinedLight, int combinedOverlay, class_4587 matrixStack, class_4588 buffer) {
        Random random = new Random();
        for (class_2350 direction : class_2350.values()) {
            random.setSeed(42L);
            AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.method_4707(null, direction, random), combinedLight, combinedOverlay);
        }
        random.setSeed(42L);
        AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.method_4707(null, null, random), combinedLight, combinedOverlay);
    }

    private static void renderQuadList(class_4587 matrixStack, class_4588 buffer, List<class_777> quads, int combinedLight, int combinedOverlay) {
        class_4587.class_4665 pose = matrixStack.method_23760();
        for (class_777 bakedQuad : quads) {
            buffer.method_22919(pose, bakedQuad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
    }

    private static class_1011 getCoverOverlay(class_3300 resourceManager) {
        class_1011 class_10112;
        block11: {
            class_3298 resource = resourceManager.method_14486(ALBUM_COVER_OVERLAY);
            try {
                class_10112 = class_1011.method_4309((InputStream)resource.method_14482());
                if (resource == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    class_1011 nativeImage = new class_1011(16, 16, false);
                    for (int k = 0; k < 16; ++k) {
                        for (int l = 0; l < 16; ++l) {
                            if (k < 8 ^ l < 8) {
                                nativeImage.method_4305(l, k, -524040);
                                continue;
                            }
                            nativeImage.method_4305(l, k, -16777216);
                        }
                    }
                    nativeImage.method_4302();
                    return nativeImage;
                }
            }
            resource.close();
        }
        return class_10112;
    }

    private void close() {
        this.covers.values().forEach(future -> future.thenAcceptAsync(data -> {
            if (!this.data.is((ModelData)data)) {
                data.close();
            }
        }, task -> RenderSystem.recordRenderCall(task::run)));
        this.covers.clear();
    }

    protected CoverData prepare(class_3300 resourceManager, class_3695 profiler) {
        return new CoverData(AlbumCoverItemRenderer.getCoverOverlay(resourceManager));
    }

    protected void apply(CoverData data, class_3300 resourceManager, class_3695 profiler) {
        if (this.data != null) {
            this.data.close();
        }
        this.data = data;
        this.close();
    }

    public void render(class_1799 stack, class_809.class_811 transformType, class_4587 matrixStack, class_4597 buffer, int packedLight, int combinedOverlay) {
        if (stack.method_7960()) {
            return;
        }
        ModelData model = stack.method_7941("CoverRecord") == null ? this.data.blank : this.covers.computeIfAbsent(stack.method_7941("CoverRecord"), __ -> {
            class_1799 coverStack = AlbumCoverItem.getCoverStack(stack).orElse(class_1799.field_8037);
            if (!coverStack.method_7960() && coverStack.method_7909() instanceof PlayableRecord) {
                return ((CompletableFuture)((PlayableRecord)coverStack.method_7909()).getAlbumCover(coverStack, class_310.method_1551().method_1487(), class_310.method_1551().method_1478()).thenApply(cover -> ModelData.of(cover).orElse(this.data.defaultCover))).exceptionally(e -> {
                    e.printStackTrace();
                    return this.data.defaultCover;
                });
            }
            return CompletableFuture.completedFuture(this.data.blank);
        }).getNow(this.data.defaultCover);
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.5, 0.5);
        model.render(stack, transformType, matrixStack, buffer, packedLight, combinedOverlay);
        matrixStack.method_22909();
    }

    public class_2960 getPollenId() {
        return new class_2960("etched", "builtin_album_cover");
    }

    public static class CoverData {
        private final DynamicModelData overlay;
        private final ModelData blank;
        private final ModelData defaultCover;

        private CoverData(class_1011 overlay) {
            this.overlay = new DynamicModelData(overlay);
            this.blank = new BakedModelData(BLANK_ALBUM_COVER);
            this.defaultCover = new BakedModelData(DEFAULT_ALBUM_COVER);
        }

        public void close() {
            this.overlay.close();
            this.blank.close();
            this.defaultCover.close();
        }

        public boolean is(ModelData data) {
            return this.overlay == data || this.blank == data || this.defaultCover == data;
        }
    }

    private static class DynamicModelData
    extends class_1058
    implements ModelData {
        private static final class_1059 ATLAS = new class_1059(new class_2960("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())));
        private class_1087 model;

        private DynamicModelData(class_1011 image) {
            super(ATLAS, new class_1058.class_4727(new class_2960("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())), image.method_4307(), image.method_4323(), class_1079.field_21768), 0, image.method_4307(), image.method_4323(), 0, 0, image);
        }

        @Override
        public void render(class_1799 stack, class_809.class_811 transformType, class_4587 matrixStack, class_4597 buffer, int packedLight, int combinedOverlay) {
            class_1087 model = this.getModel();
            if (model.method_4713()) {
                return;
            }
            model.method_4709().method_3503(transformType).method_23075(transformType == class_809.class_811.field_4321 || transformType == class_809.class_811.field_4323, matrixStack);
            matrixStack.method_22904(-0.5, -0.5, -0.5);
            AlbumCoverItemRenderer.renderModelLists(model, packedLight, combinedOverlay, matrixStack, class_918.method_29711((class_4597)buffer, (class_1921)class_1921.method_23576((class_2960)this.method_4598()), (boolean)false, (boolean)stack.method_7958()));
        }

        private class_1087 getModel() {
            if (this.model == null) {
                class_3695 profiler = class_310.method_1551().method_16011();
                profiler.method_15396("buildAlbumCoverModel");
                this.model = ITEM_MODEL_GENERATOR.method_3479(material -> this, MODEL).method_3446(null, MODEL, material -> this, (class_3665)class_1086.field_5350, this.method_4598(), false);
                profiler.method_15407();
            }
            if (class_310.method_1551().method_1531().method_34590(this.method_4598(), null) == null) {
                class_310.method_1551().method_1531().method_4616(this.method_4598(), (class_1044)new class_1043(this.field_5262[0]));
            }
            return this.model;
        }

        public class_1011 getImage() {
            return this.field_5262[0];
        }

        public float method_23842() {
            return 0.0f;
        }

        public class_4588 method_24108(class_4588 buffer) {
            return buffer;
        }

        @Override
        public void close() {
            super.close();
            class_310.method_1551().method_1531().method_4615(this.method_4598());
        }
    }

    private static interface ModelData {
        public static Optional<ModelData> of(AlbumCover cover) {
            if (cover instanceof ModelAlbumCover) {
                return Optional.of(new BakedModelData(((ModelAlbumCover)cover).getModel()));
            }
            if (cover instanceof ImageAlbumCover) {
                return Optional.of(new DynamicModelData(((ImageAlbumCover)cover).getImage()));
            }
            return Optional.empty();
        }

        public void render(class_1799 var1, class_809.class_811 var2, class_4587 var3, class_4597 var4, int var5, int var6);

        public void close();
    }

    private static class BakedModelData
    implements ModelData {
        private final class_1091 model;
        private boolean rendering;

        private BakedModelData(class_1091 model) {
            this.model = model;
        }

        @Override
        public void render(class_1799 stack, class_809.class_811 transformType, class_4587 matrixStack, class_4597 buffer, int packedLight, int combinedOverlay) {
            class_1092 modelManager = class_310.method_1551().method_1554();
            class_1087 model = this.rendering ? modelManager.method_4744() : modelManager.method_4742(this.model);
            this.rendering = true;
            class_310.method_1551().method_1480().method_23179(stack, transformType, transformType == class_809.class_811.field_4321 || transformType == class_809.class_811.field_4323, matrixStack, buffer, packedLight, combinedOverlay, model);
            this.rendering = false;
        }

        @Override
        public void close() {
        }
    }
}

