/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class AlbumJukeboxScreen
extends class_465<AlbumJukeboxMenu> {
    private static final class_2960 CONTAINER_LOCATION = new class_2960("textures/gui/container/dispenser.png");
    private static final class_2561 NOW_PLAYING = new class_2588("screen.etched.album_jukebox.now_playing").method_27692(class_124.field_1054);
    private int playingIndex;
    private int playingTrack;

    public AlbumJukeboxScreen(AlbumJukeboxMenu dispenserMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)dispenserMenu, inventory, component);
    }

    private void update(boolean next) {
        class_638 level = this.field_22787.field_1687;
        if (level == null || !((AlbumJukeboxMenu)this.field_2797).isInitialized()) {
            return;
        }
        class_2586 blockEntity = level.method_8321(((AlbumJukeboxMenu)this.field_2797).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity) || !((AlbumJukeboxBlockEntity)blockEntity).isPlaying()) {
            return;
        }
        AlbumJukeboxBlockEntity albumJukebox = (AlbumJukeboxBlockEntity)blockEntity;
        int oldIndex = albumJukebox.getPlayingIndex();
        int oldTrack = albumJukebox.getTrack();
        if (next) {
            albumJukebox.next();
        } else {
            albumJukebox.previous();
        }
        if ((albumJukebox.getPlayingIndex() == oldIndex && albumJukebox.getTrack() != oldTrack || albumJukebox.recalculatePlayingIndex(!next)) && albumJukebox.getPlayingIndex() != -1) {
            SoundTracker.playAlbum(albumJukebox, albumJukebox.method_11010(), level, ((AlbumJukeboxMenu)this.field_2797).getPos(), true);
            EtchedMessages.PLAY.sendToServer((PollinatedPacket)new SetAlbumJukeboxTrackPacket(albumJukebox.getPlayingIndex(), albumJukebox.getTrack()));
        }
    }

    protected void method_25426() {
        super.method_25426();
        int buttonPadding = 6;
        class_2585 last = new class_2585("Last");
        class_2585 next = new class_2585("Next");
        class_327 font = class_310.method_1551().field_1772;
        this.method_37063((class_364)new class_4185(this.field_2776 + 7 + (54 - font.method_27525((class_5348)last)) / 2 - buttonPadding, this.field_2800 + 33, font.method_27525((class_5348)last) + 2 * buttonPadding, 20, (class_2561)last, b -> this.update(false)));
        this.method_37063((class_364)new class_4185(this.field_2776 + 115 + (54 - font.method_27525((class_5348)last)) / 2 - buttonPadding, this.field_2800 + 33, font.method_27525((class_5348)next) + 2 * buttonPadding, 20, (class_2561)next, b -> this.update(true)));
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
    }

    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, i, j, f);
        this.method_2380(poseStack, i, j);
    }

    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)CONTAINER_LOCATION);
        int guiLeft = (this.field_22789 - this.field_2792) / 2;
        int guiTop = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(poseStack, guiLeft, guiTop, 0, 0, this.field_2792, this.field_2779);
        this.playingIndex = -1;
        this.playingTrack = 0;
        class_638 level = this.field_22787.field_1687;
        if (level == null || !((AlbumJukeboxMenu)this.field_2797).isInitialized()) {
            return;
        }
        class_2586 blockEntity = level.method_8321(((AlbumJukeboxMenu)this.field_2797).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        this.playingIndex = ((AlbumJukeboxBlockEntity)blockEntity).getPlayingIndex();
        this.playingTrack = ((AlbumJukeboxBlockEntity)blockEntity).getTrack();
        if (this.playingIndex != -1) {
            int x = this.playingIndex % 3;
            int y = this.playingIndex / 3;
            this.method_25296(poseStack, guiLeft + 62 + x * 18, guiTop + 17 + y * 18, guiLeft + 78 + x * 18, guiTop + 33 + y * 18, 1022820096, 1022820096);
        }
    }

    protected void method_2380(class_4587 poseStack, int i, int j) {
        if (((AlbumJukeboxMenu)this.field_2797).method_34255().method_7960() && this.field_2787 != null && this.field_2787.method_7681()) {
            class_1799 stack = this.field_2787.method_7677();
            List tooltip = this.method_25408(stack);
            if (this.field_2787.field_7874 == this.playingIndex) {
                if (this.playingTrack >= 0 && PlayableRecord.getStackTrackCount(stack) > 0) {
                    Optional<TrackData[]> optional = PlayableRecord.getStackMusic(stack).filter(tracks -> this.playingTrack < ((TrackData[])tracks).length);
                    if (optional.isPresent()) {
                        TrackData track = optional.get()[this.playingTrack];
                        tooltip.add(NOW_PLAYING.method_27661().method_27693(": ").method_10852(track.getDisplayName()).method_27693(" (" + (this.playingTrack + 1) + "/" + optional.get().length + ")"));
                    } else {
                        tooltip.add(NOW_PLAYING);
                    }
                } else {
                    tooltip.add(NOW_PLAYING);
                }
            }
            this.method_30901(poseStack, tooltip, i, j);
        }
    }
}

