/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.sound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class SoundCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Path CACHE_FOLDER = class_310.method_1551().field_1697.toPath().resolve("etched-sounds");
    private static final ReentrantLock DOWNLOAD_LOCK = new ReentrantLock();
    private static final ReentrantLock METADATA_LOCK = new ReentrantLock();
    private static final ReentrantLock IO_LOCK = new ReentrantLock();
    private static final Path CACHE_METADATA_LOCATION = CACHE_FOLDER.resolve("cache.json");
    private static final int METADATA_WRITE_TIME = 5000;
    private static volatile JsonObject CACHE_METADATA = new JsonObject();
    private static volatile long nextWriteTime = Long.MAX_VALUE;
    private static final Map<String, CompletableFuture<AudioSource>> DOWNLOADING = new HashMap<String, CompletableFuture<AudioSource>>();
    private static Map<String, Path> files = new ConcurrentHashMap<String, Path>();

    private SoundCache() {
    }

    private static synchronized void writeMetadata() {
        LOGGER.debug("Writing cache metadata to file.");
        try (FileOutputStream os = new FileOutputStream(CACHE_METADATA_LOCATION.toFile());){
            if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
            }
            IOUtils.write((String)GSON.toJson((JsonElement)CACHE_METADATA), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache metadata", (Throwable)e);
        }
    }

    public static CompletableFuture<AudioSource> getAudioStream(String url, @Nullable DownloadProgressListener listener, AudioSource.AudioFileType type) {
        CompletionStage<AudioSource> future;
        if (DOWNLOADING.containsKey(url) && !(future = DOWNLOADING.get(url)).isDone()) {
            return future;
        }
        try {
            DOWNLOAD_LOCK.lock();
            future = ((CompletableFuture)SoundSourceManager.getAudioSource(url, listener, class_310.method_1551().method_1487(), type).handle((source, e) -> {
                if (e != null) {
                    if (listener != null) {
                        listener.onFail();
                    }
                    throw new CompletionException((Throwable)e);
                }
                return source;
            })).thenApplyAsync(source -> {
                DOWNLOADING.remove(url);
                return source;
            }, (Executor)class_310.method_1551());
            DOWNLOADING.put(url, (CompletableFuture<AudioSource>)future);
            CompletionStage<AudioSource> completionStage = future;
            return completionStage;
        }
        catch (Exception e2) {
            if (listener != null) {
                listener.onFail();
            }
            throw new CompletionException("Failed to load audio into cache", e2);
        }
        finally {
            DOWNLOAD_LOCK.unlock();
        }
    }

    public static boolean isValid(Path soundFile, String url) {
        String key = DigestUtils.md5Hex((String)url);
        if (!Files.exists(soundFile, new LinkOption[0])) {
            return false;
        }
        if (CACHE_METADATA.has(key) && CACHE_METADATA.get(key).isJsonPrimitive() && CACHE_METADATA.get(key).getAsJsonPrimitive().isNumber()) {
            long now = System.currentTimeMillis() / 1000L;
            long expirationDate = CACHE_METADATA.get(key).getAsLong();
            return expirationDate - now > 0L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache(Path soundFile, String url, long timeout, TimeUnit unit, InputStream stream) {
        try {
            try {
                IO_LOCK.lock();
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                }
                Files.copy(stream, soundFile, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                IO_LOCK.unlock();
            }
            try {
                METADATA_LOCK.lock();
                CACHE_METADATA.addProperty(DigestUtils.md5Hex((String)url), (Number)(System.currentTimeMillis() / 1000L + unit.toSeconds(timeout)));
                nextWriteTime = System.currentTimeMillis() + 5000L;
            }
            finally {
                METADATA_LOCK.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to write sound: " + url, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static Path resolveFilePath(String hash, boolean temporary) throws IOException {
        if (temporary) {
            return SoundCache.getTemporaryFile(hash);
        }
        if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
            Files.createDirectories(CACHE_FOLDER, new FileAttribute[0]);
        }
        return CACHE_FOLDER.resolve(hash);
    }

    private static Path getTemporaryFile(String hash) throws IOException {
        if (files == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (!files.containsKey(hash)) {
            files.put(hash, Files.createTempFile(hash, null, new FileAttribute[0]));
        }
        return files.get(hash);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<SoundCache> clazz = SoundCache.class;
            synchronized (SoundCache.class) {
                Map<String, Path> theFiles = files;
                files = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                theFiles.keySet().forEach(arg_0 -> ((JsonObject)CACHE_METADATA).remove(arg_0));
                ArrayList<Path> toBeDeleted = new ArrayList<Path>(theFiles.values());
                theFiles.clear();
                Collections.reverse(toBeDeleted);
                for (Path filename : toBeDeleted) {
                    try {
                        Files.deleteIfExists(filename);
                    }
                    catch (Exception exception) {}
                }
                SoundCache.writeMetadata();
                return;
            }
        }));
        if (Files.exists(CACHE_METADATA_LOCATION, new LinkOption[0])) {
            LOGGER.debug("Reading cache metadata from file.");
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(CACHE_METADATA_LOCATION.toFile()));){
                CACHE_METADATA = new JsonParser().parse((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache metadata", (Throwable)e);
            }
        }
        TickEvents.CLIENT_POST.register(() -> {
            if (nextWriteTime == Long.MAX_VALUE) {
                return;
            }
            if (System.currentTimeMillis() - nextWriteTime > 0L) {
                nextWriteTime = Long.MAX_VALUE;
                class_156.method_27958().execute(SoundCache::writeMetadata);
            }
        });
    }
}

