/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.BoomboxMenu;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends class_1792
implements ContainerItem {
    private static final Map<Integer, class_1799> PLAYING_RECORDS = new Int2ObjectArrayMap();
    private static final class_2561 PAUSE = new class_2588("item.etched.boombox.pause", new Object[]{new class_2572("key.sneak"), new class_2572("key.use")}).method_27692(class_124.field_1080);
    private static final class_2561 RECORDS = new class_2588("item.etched.boombox.records");
    public static final class_2561 PAUSED = new class_2588("item.etched.boombox.paused").method_27692(class_124.field_1054);

    public BoomboxItem(class_1792.class_1793 properties) {
        super(properties);
    }

    private static void updatePlaying(class_1297 entity, class_1799 record) {
        if (!class_1799.method_7973((class_1799)PLAYING_RECORDS.getOrDefault(entity.method_5628(), class_1799.field_8037), (class_1799)record)) {
            SoundTracker.playBoombox(entity.method_5628(), record);
            if (record.method_7960()) {
                PLAYING_RECORDS.remove(entity.method_5628());
            } else {
                PLAYING_RECORDS.put(entity.method_5628(), record);
            }
        }
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!entity.field_6002.method_8608()) {
            return false;
        }
        BoomboxItem.updatePlaying((class_1297)entity, BoomboxItem.hasRecord(stack) && !BoomboxItem.isPaused(stack) ? BoomboxItem.getRecord(stack) : class_1799.field_8037);
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_21823()) {
            BoomboxItem.setPaused(stack, !BoomboxItem.isPaused(stack));
            return class_1271.method_29237((Object)stack, (boolean)level.method_8608());
        }
        if (!((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return class_1271.method_22431((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public class_1703 constructMenu(int containerId, class_1661 inventory, class_1657 player, int index) {
        return new BoomboxMenu(containerId, inventory, index);
    }

    public boolean method_31565(class_1799 boombox, class_1735 slot, class_5536 clickAction, class_1657 player) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != class_5536.field_27014) {
            return false;
        }
        class_1799 clickItem = slot.method_7677();
        if (clickItem.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            BoomboxItem.removeOne(boombox).ifPresent(key -> BoomboxItem.setRecord(boombox, slot.method_32756(key)));
        } else if (BoomboxItem.canAdd(boombox, clickItem)) {
            this.playInsertSound((class_1297)player);
            BoomboxItem.setRecord(boombox, slot.method_32753(clickItem.method_7947(), 1, player).method_7971(1));
        }
        return true;
    }

    public boolean method_31566(class_1799 boombox, class_1799 clickItem, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == class_5536.field_27014 && slot.method_32754(player)) {
            if (clickItem.method_7960()) {
                BoomboxItem.removeOne(boombox).ifPresent(removedKey -> {
                    this.playRemoveOneSound((class_1297)player);
                    slotAccess.method_32332(removedKey);
                });
            } else if (BoomboxItem.canAdd(boombox, clickItem)) {
                this.playInsertSound((class_1297)player);
                BoomboxItem.setRecord(boombox, clickItem.method_7971(1));
            }
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add(PAUSE);
        if (BoomboxItem.hasRecord(stack)) {
            class_1799 record = BoomboxItem.getRecord(stack);
            LinkedList records = new LinkedList();
            record.method_7909().method_7851(record, level, records, isAdvanced);
            if (!records.isEmpty()) {
                tooltipComponents.add(class_2585.field_24366);
                tooltipComponents.add(RECORDS);
                tooltipComponents.addAll(records);
            }
        }
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    @Nullable
    public static class_1268 getPlayingHand(class_1309 entity) {
        if (!PLAYING_RECORDS.containsKey(entity.method_5628())) {
            return null;
        }
        class_1799 stack = entity.method_6047();
        if (stack.method_7909() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return class_1268.field_5808;
        }
        stack = entity.method_6079();
        if (stack.method_7909() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return class_1268.field_5810;
        }
        return null;
    }

    public static boolean isPaused(class_1799 stack) {
        if (!(stack.method_7909() instanceof BoomboxItem)) {
            return false;
        }
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10577("Paused");
    }

    public static boolean hasRecord(class_1799 stack) {
        if (!(stack.method_7909() instanceof BoomboxItem)) {
            return false;
        }
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10573("Record", 10);
    }

    public static class_1799 getRecord(class_1799 stack) {
        if (!(stack.method_7909() instanceof BoomboxItem)) {
            return class_1799.field_8037;
        }
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10573("Record", 10) ? class_1799.method_7915((class_2487)compoundTag.method_10562("Record")) : class_1799.field_8037;
    }

    public static void setRecord(class_1799 stack, class_1799 record) {
        if (!(stack.method_7909() instanceof BoomboxItem)) {
            return;
        }
        if (record.method_7960()) {
            stack.method_7983("Record");
        } else {
            stack.method_7948().method_10566("Record", (class_2520)record.method_7953(new class_2487()));
        }
    }

    public static void setPaused(class_1799 stack, boolean paused) {
        if (!(stack.method_7909() instanceof BoomboxItem)) {
            return;
        }
        if (!paused) {
            stack.method_7983("Paused");
        } else {
            stack.method_7948().method_10556("Paused", true);
        }
    }

    private static Optional<class_1799> removeOne(class_1799 boombox) {
        if (!BoomboxItem.hasRecord(boombox)) {
            return Optional.empty();
        }
        class_1799 record = BoomboxItem.getRecord(boombox);
        if (record.method_7960()) {
            return Optional.empty();
        }
        BoomboxItem.setRecord(boombox, class_1799.field_8037);
        return Optional.of(record);
    }

    private static boolean canAdd(class_1799 boombox, class_1799 record) {
        if (!boombox.method_31574(EtchedItems.BOOMBOX.get()) || !(record.method_7909() instanceof PlayableRecord)) {
            return false;
        }
        return BoomboxItem.getRecord(boombox).method_7960();
    }

    static {
        TickEvents.LIVING_PRE.register(entity -> {
            if (!entity.field_6002.method_8608()) {
                return true;
            }
            class_1799 newPlayingRecord = class_1799.field_8037;
            class_1799 mainStack = entity.method_6047();
            class_1799 offStack = entity.method_6079();
            if (mainStack.method_7909() instanceof BoomboxItem && BoomboxItem.hasRecord(mainStack) && !BoomboxItem.isPaused(mainStack)) {
                newPlayingRecord = BoomboxItem.getRecord(mainStack);
            } else if (offStack.method_7909() instanceof BoomboxItem && BoomboxItem.hasRecord(offStack) && !BoomboxItem.isPaused(offStack)) {
                newPlayingRecord = BoomboxItem.getRecord(offStack);
            }
            if (entity instanceof class_1657 && newPlayingRecord.method_7960() && class_310.method_1551().field_1719 == entity) {
                class_1661 inventory = ((class_1657)entity).method_31548();
                for (class_1799 stack : inventory.field_7547) {
                    if (!(stack.method_7909() instanceof BoomboxItem) || !BoomboxItem.hasRecord(stack) || BoomboxItem.isPaused(stack)) continue;
                    newPlayingRecord = BoomboxItem.getRecord(stack);
                }
            }
            BoomboxItem.updatePlaying((class_1297)entity, newPlayingRecord);
            return true;
        });
    }
}

