/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core;

import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.client.render.entity.JukeboxMinecartRenderer;
import gg.moonflower.etched.client.render.item.AlbumCoverItemRenderer;
import gg.moonflower.etched.client.render.model.EtchedModelLayers;
import gg.moonflower.etched.client.screen.AlbumCoverScreen;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.BoomboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.BoomboxItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.sound.download.BandcampSource;
import gg.moonflower.etched.common.sound.download.SoundCloudSource;
import gg.moonflower.etched.core.EtchedConfig;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedEntities;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedRecipes;
import gg.moonflower.etched.core.registry.EtchedSounds;
import gg.moonflower.etched.core.registry.EtchedVillagers;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.event.events.entity.ModifyTradesEvents;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.client.ColorRegistry;
import gg.moonflower.pollen.api.registry.client.EntityRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ItemPredicateRegistry;
import gg.moonflower.pollen.api.registry.client.ItemRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ModelRegistry;
import gg.moonflower.pollen.api.registry.client.RenderTypeRegistry;
import gg.moonflower.pollen.api.registry.client.ScreenRegistry;
import java.util.function.Supplier;
import net.minecraft.class_1091;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5601;
import net.minecraft.class_580;

public class Etched {
    public static final String MOD_ID = "etched";
    public static final EtchedConfig.Client CLIENT_CONFIG = (EtchedConfig.Client)ConfigManager.register((String)"etched", (PollinatedConfigType)PollinatedConfigType.CLIENT, EtchedConfig.Client::new);
    public static final EtchedConfig.Server SERVER_CONFIG = (EtchedConfig.Server)ConfigManager.register((String)"etched", (PollinatedConfigType)PollinatedConfigType.SERVER, EtchedConfig.Server::new);
    public static final Platform PLATFORM = Platform.builder((String)"etched").commonInit(Etched::commonInit).commonPostInit(Etched::commonPostInit).clientInit(Etched::clientInit).clientPostInit(Etched::clientPostInit).build();

    public static void commonInit() {
        EtchedBlocks.BLOCKS.register(PLATFORM);
        EtchedBlocks.BLOCK_ENTITIES.register(PLATFORM);
        EtchedItems.ITEMS.register(PLATFORM);
        EtchedEntities.ENTITIES.register(PLATFORM);
        EtchedMenus.MENUS.register(PLATFORM);
        EtchedSounds.SOUNDS.register(PLATFORM);
        EtchedVillagers.POI_TYPES.register(PLATFORM);
        EtchedVillagers.PROFESSIONS.register(PLATFORM);
        EtchedRecipes.RECIPES.register(PLATFORM);
        EtchedMessages.init();
        ModifyTradesEvents.VILLAGER.register(context -> {
            if (context.getProfession() != EtchedVillagers.BARD.get()) {
                return;
            }
            ModifyTradesEvents.TradeRegistry tier1 = context.getTrades(1);
            tier1.add((class_1935)class_1802.field_8144, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8731, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8075, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_35358, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8643, 1, 2, 16, 2, true);
            tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
            ModifyTradesEvents.TradeRegistry tier2 = context.getTrades(2);
            tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
            tier2.add(EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
            ModifyTradesEvents.TradeRegistry tier3 = context.getTrades(3);
            tier3.add((class_1935)class_2246.field_10460, 6, 1, 16, 2, false);
            tier3.add((class_1935)class_2246.field_10359, 12, 1, 8, 2, false);
            tier3.add((class_1935)class_2246.field_10446, 8, 1, 32, 4, false);
            tier3.add((class_1935)class_2246.field_10166, 24, 1, 8, 4, false);
            tier3.add((class_1935)class_2246.field_10225, 36, 1, 4, 8, false);
            tier3.add((class_1935)class_2246.field_10205, 48, 1, 2, 10, false);
            ModifyTradesEvents.TradeRegistry tier4 = context.getTrades(4);
            tier3.add((class_1935)class_1802.field_8565, 26, 1, 4, 30, false);
            tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
            tier4.add(EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
            ModifyTradesEvents.TradeRegistry tier5 = context.getTrades(5);
            tier5.add((class_1935)class_1802.field_8477, 8, 1, 8, 40, true);
            tier5.add((class_1935)class_1802.field_27063, 1, 8, 10, 40, true);
            class_2378.field_11142.method_40266(class_3489.field_15541).ifPresent(tag -> tag.method_40239().forEach(item -> tier5.add((class_1935)item.comp_349(), 10, 1, 4, 40, true)));
        });
    }

    public static void clientInit() {
        RegisterAtlasSpriteEvent.event((class_2960)class_1723.field_21668).register((atlas, registry) -> {
            registry.accept(new class_2960(MOD_ID, "item/empty_etching_table_slot_music_disc"));
            registry.accept(new class_2960(MOD_ID, "item/empty_etching_table_slot_music_label"));
        });
        ClientLoading.load();
        ModelRegistry.registerFactory((resourceManager, out) -> {
            String folder = "models/item/etched_album_cover/";
            for (class_2960 animationLocation : resourceManager.method_14488(folder, name -> name.endsWith(".json"))) {
                out.accept(new class_1091(new class_2960(animationLocation.method_12836(), animationLocation.method_12832().substring(12, animationLocation.method_12832().length() - 5)), "inventory"));
            }
        });
        ColorRegistry.register((stack, index) -> index == 0 || index == 1 ? MusicLabelItem.getLabelColor(stack) : -1, (Supplier[])new Supplier[]{EtchedItems.MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index == 0 ? ComplexMusicLabelItem.getPrimaryColor(stack) : (index == 1 ? ComplexMusicLabelItem.getSecondaryColor(stack) : -1), (Supplier[])new Supplier[]{EtchedItems.COMPLEX_MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index > 0 ? -1 : ((BlankMusicDiscItem)stack.method_7909()).method_7800(stack), (Supplier[])new Supplier[]{EtchedItems.BLANK_MUSIC_DISC});
        ColorRegistry.register((stack, index) -> index == 0 ? EtchedMusicDiscItem.getDiscColor(stack) : (EtchedMusicDiscItem.getPattern(stack).isColorable() ? (index == 1 ? EtchedMusicDiscItem.getLabelPrimaryColor(stack) : (index == 2 ? EtchedMusicDiscItem.getLabelSecondaryColor(stack) : -1)) : -1), (Supplier[])new Supplier[]{EtchedItems.ETCHED_MUSIC_DISC});
        EntityRendererRegistry.registerLayerDefinition((class_5601)EtchedModelLayers.JUKEBOX_MINECART, class_580::method_32020);
        EntityRendererRegistry.register(EtchedEntities.JUKEBOX_MINECART, JukeboxMinecartRenderer::new);
        AlbumCoverItemRenderer.init();
    }

    public static void commonPostInit(Platform.ModSetupContext ctx) {
        SoundSourceManager.registerSource(new SoundCloudSource());
        SoundSourceManager.registerSource(new BandcampSource());
        ctx.enqueueWork(EtchedVillagers::registerVillages);
    }

    public static void clientPostInit(Platform.ModSetupContext ctx) {
        ctx.enqueueWork(() -> {
            ScreenRegistry.register(EtchedMenus.ETCHING_MENU.get(), EtchingScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_JUKEBOX_MENU.get(), AlbumJukeboxScreen::new);
            ScreenRegistry.register(EtchedMenus.BOOMBOX_MENU.get(), BoomboxScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_COVER_MENU.get(), AlbumCoverScreen::new);
            ScreenRegistry.register(EtchedMenus.RADIO_MENU.get(), RadioScreen::new);
            ItemPredicateRegistry.register((class_1792)EtchedItems.BOOMBOX.get(), (class_2960)new class_2960(MOD_ID, "playing"), (stack, level, entity, i) -> {
                if (!(entity instanceof class_1657)) {
                    return 0.0f;
                }
                class_1268 hand = BoomboxItem.getPlayingHand(entity);
                return hand != null && stack == entity.method_5998(hand) ? 1.0f : 0.0f;
            });
            ItemPredicateRegistry.register((class_1792)EtchedItems.ETCHED_MUSIC_DISC.get(), (class_2960)new class_2960(MOD_ID, "pattern"), (stack, level, entity, i) -> (float)EtchedMusicDiscItem.getPattern(stack).ordinal() / 10.0f);
        });
        RenderTypeRegistry.register((class_2248)EtchedBlocks.ETCHING_TABLE.get(), (class_1921)class_1921.method_23581());
        RenderTypeRegistry.register((class_2248)EtchedBlocks.RADIO.get(), (class_1921)class_1921.method_23581());
        ItemRendererRegistry.registerHandModel((class_1935)((class_1935)EtchedItems.BOOMBOX.get()), (class_1091)new class_1091(new class_2960(MOD_ID, "boombox_in_hand"), "inventory"));
        ItemRendererRegistry.registerRenderer((class_1935)((class_1935)EtchedItems.ALBUM_COVER.get()), (DynamicItemRenderer)AlbumCoverItemRenderer.INSTANCE);
    }

    private static class ClientLoading {
        private ClientLoading() {
        }

        private static void load() {
            ModelRegistry.registerSpecial((class_2960)new class_1091(new class_2960(Etched.MOD_ID, "boombox_in_hand"), "inventory"));
        }
    }
}

