/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3815;
import net.minecraft.class_3834;
import net.minecraft.class_3836;
import net.minecraft.class_3852;
import net.minecraft.class_3868;
import net.minecraft.class_3870;
import net.minecraft.class_4158;
import net.minecraft.class_5458;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_6880;

public class EtchedVillagers {
    public static final PollinatedRegistry<class_3852> PROFESSIONS = PollinatedRegistry.create((class_2378)class_2378.field_17167, (String)"etched");
    public static final PollinatedRegistry<class_4158> POI_TYPES = PollinatedRegistry.create((class_2378)class_2378.field_18792, (String)"etched");
    public static final Supplier<class_4158> BARD_POI = POI_TYPES.register("bard", () -> class_4158.method_20354((class_4158)new class_4158("etched:bard", (Set)ImmutableSet.builder().addAll((Iterable)class_2246.field_10179.method_9595().method_11662()).build(), 1, 1)));
    public static final Supplier<class_3852> BARD = PROFESSIONS.register("bard", () -> new class_3852("etched:bard", BARD_POI.get(), ImmutableSet.of(), ImmutableSet.of(), null));

    public static void registerVillages() {
        class_3815.method_16754();
        class_3868.method_17037();
        class_3834.method_16844();
        class_3836.method_16845();
        class_3870.method_17038();
        EtchedVillagers.createVillagePiece("plains", "bard_house", 1, 2, (class_6880<class_5497>)class_5469.field_26264, (class_6880<class_5497>)class_5469.field_26259);
        EtchedVillagers.createVillagePiece("desert", "bard_house", 1, 2, (class_6880<class_5497>)class_5469.field_26263);
        EtchedVillagers.createVillagePiece("savanna", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26260);
        EtchedVillagers.createVillagePiece("snowy", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26261);
        EtchedVillagers.createVillagePiece("taiga", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26264, (class_6880<class_5497>)class_5469.field_26262);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, class_6880<class_5497> zombieProcessor) {
        EtchedVillagers.createVillagePiece(village, name, houseId, weight, (class_6880<class_5497>)class_5469.field_26688, zombieProcessor);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, class_6880<class_5497> normalProcessor, class_6880<class_5497> zombieProcessor) {
        EtchedVillagers.addToPool(new class_2960("village/" + village + "/houses"), new class_2960("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), normalProcessor, weight);
        EtchedVillagers.addToPool(new class_2960("village/" + village + "/zombie/houses"), new class_2960("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), zombieProcessor, weight);
    }

    private static void addToPool(class_2960 poolId, class_2960 pieceId, class_6880<class_5497> processorList, int weight) {
        class_3785 pool = (class_3785)class_5458.field_25932.method_10223(poolId);
        if (pool == null) {
            return;
        }
        class_3784 piece = (class_3784)class_3784.method_30426((String)pieceId.toString(), processorList).apply(class_3785.class_3786.field_16687);
        List<class_3784> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        List<Pair<class_3784, Integer>> rawTemplates = ((StructureTemplatePoolAccessor)pool).getRawTemplates();
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
        rawTemplates.add((Pair<class_3784, Integer>)Pair.of((Object)piece, (Object)weight));
    }
}

