/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.source;

import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.ProgressTrackingInputStream;
import gg.moonflower.etched.client.sound.SoundCache;
import gg.moonflower.etched.core.util.AsyncInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3521;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public interface AudioSource {
    public static final Logger LOGGER = LogManager.getLogger();

    public static Map<String, String> getDownloadHeaders() {
        Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
        map.put("X-Minecraft-Username", class_310.method_1551().method_1548().method_1676());
        map.put("X-Minecraft-UUID", class_310.method_1551().method_1548().method_1673());
        return map;
    }

    public static AsyncInputStream.InputStreamSupplier downloadTo(Path file, URL url, @Nullable DownloadProgressListener progressListener, AudioFileType type) {
        if (progressListener != null) {
            progressListener.progressStartRequest((class_2561)class_2561.method_43471((String)"resourcepack.requesting"));
        }
        try {
            String ageHeader;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            AudioSource.getDownloadHeaders().forEach(connection::setRequestProperty);
            long contentLength = connection.getContentLengthLong();
            long cacheTime = Long.MAX_VALUE;
            int cachePriority = 0;
            boolean cache = true;
            String cacheControl = connection.getHeaderField("Cache-Control");
            if (cacheControl != null) {
                String[] parts;
                for (String part : parts = cacheControl.split(",")) {
                    try {
                        String[] entry = part.split("=");
                        String name = entry[0].trim();
                        String value = entry.length > 1 ? entry[1].trim() : null;
                        switch (name) {
                            case "max-age": {
                                if (cachePriority > 0) break;
                                try {
                                    cacheTime = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    LOGGER.error("Invalid max-age: " + value);
                                }
                                break;
                            }
                            case "s-maxage": {
                                cachePriority = 1;
                                try {
                                    cacheTime = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    LOGGER.error("Invalid s-maxage: " + value);
                                }
                                break;
                            }
                            case "no-store": {
                                cache = false;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Invalid response header: {}", (Object)part, (Object)e);
                    }
                }
            }
            if ((ageHeader = connection.getHeaderField("Age")) != null) {
                try {
                    cacheTime -= (long)Integer.parseInt(ageHeader);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid Age: " + ageHeader);
                }
            }
            if (contentLength <= 0L || cacheTime <= 0L || !cache) {
                if (!type.isStream()) {
                    throw new IOException("The provided URL is a stream, but that is not supported");
                }
                Files.deleteIfExists(file);
                return () -> new AsyncInputStream(url::openStream, 8192, 8, (Executor)class_3521.field_15664);
            }
            if (!type.isFile()) {
                throw new IOException("The provided URL is a file, but that is not supported");
            }
            if (SoundCache.isValid(file, file.getFileName().toString())) {
                return () -> Files.newInputStream(file.toFile().toPath(), new OpenOption[0]);
            }
            if (contentLength > 0x6400000L) {
                throw new IOException("Filesize is bigger than maximum allowed (file is " + contentLength + ", limit is 104857600)");
            }
            SoundCache.updateCache(file, file.getFileName().toString(), cacheTime, TimeUnit.SECONDS, new ProgressTrackingInputStream(connection.getInputStream(), contentLength, progressListener){

                @Override
                public int read() throws IOException {
                    int value = super.read();
                    if (this.getRead() > 0x6400000) {
                        throw new IOException("Filesize was bigger than maximum allowed (got >= " + this.getRead() + ", limit was 104857600)");
                    }
                    return value;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int value = super.read(b, off, len);
                    if (this.getRead() > 0x6400000) {
                        throw new IOException("Filesize was bigger than maximum allowed (got >= " + this.getRead() + ", limit was 104857600)");
                    }
                    return value;
                }
            });
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
        return () -> Files.newInputStream(file, new OpenOption[0]);
    }

    public CompletableFuture<InputStream> openStream();

    public static enum AudioFileType {
        FILE(true, false),
        STREAM(false, true),
        BOTH(true, true);

        private final boolean file;
        private final boolean stream;

        private AudioFileType(boolean file, boolean stream) {
            this.file = file;
            this.stream = stream;
        }

        public boolean isFile() {
            return this.file;
        }

        public boolean isStream() {
            return this.stream;
        }
    }
}

