/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4234;

public class RawAudioStream
implements class_4234 {
    private final AudioFormat format;
    private final InputStream input;

    public RawAudioStream(AudioFormat format, InputStream input) {
        this.format = format;
        this.input = input;
    }

    private static ByteBuffer convertAudioBytes(byte[] audio_bytes, boolean two_bytes_data, ByteOrder order) {
        ByteBuffer dest = ByteBuffer.allocateDirect(audio_bytes.length);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(audio_bytes);
        src.order(order);
        if (two_bytes_data) {
            ShortBuffer dest_short = dest.asShortBuffer();
            ShortBuffer src_short = src.asShortBuffer();
            while (src_short.hasRemaining()) {
                dest_short.put(src_short.get());
            }
        } else {
            while (src.hasRemaining()) {
                dest.put(src.get());
            }
        }
        dest.rewind();
        return dest;
    }

    public AudioFormat method_19719() {
        return this.format;
    }

    public ByteBuffer method_19720(int amount) throws IOException {
        int total;
        int read;
        byte[] buf = new byte[amount];
        for (total = 0; total < buf.length && (read = this.input.read(buf, total, buf.length - total)) != -1; total += read) {
        }
        byte[] result = buf;
        if (buf.length != total) {
            result = new byte[total];
            System.arraycopy(buf, 0, result, 0, result.length);
        }
        return RawAudioStream.convertAudioBytes(result, this.format.getSampleSizeInBits() == 16, this.format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public void close() throws IOException {
        this.input.close();
    }
}

