/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.util;

import gg.moonflower.etched.api.util.DownloadProgressListener;
import net.minecraft.class_2561;

public class AccumulatingDownloadProgressListener
implements DownloadProgressListener {
    private final DownloadProgressListener parent;
    private final int count;
    private boolean started;
    private int success;
    private int sizesReceived;

    public AccumulatingDownloadProgressListener(DownloadProgressListener parent, int count) {
        this.parent = parent;
        this.count = count;
    }

    @Override
    public void progressStartRequest(class_2561 component) {
        if (!this.started) {
            this.parent.progressStartRequest(component);
            this.started = true;
        }
    }

    @Override
    public void progressStartDownload(float size) {
        ++this.sizesReceived;
        if (this.sizesReceived >= this.count) {
            this.parent.progressStartDownload(size);
        }
    }

    @Override
    public void progressStagePercentage(int percentage) {
    }

    @Override
    public void progressStartLoading() {
        if (this.sizesReceived >= this.count) {
            this.parent.progressStartLoading();
        }
    }

    @Override
    public void onSuccess() {
        ++this.success;
        if (this.sizesReceived >= this.count) {
            this.parent.progressStage((float)this.success / (float)this.sizesReceived);
        }
        if (this.success >= this.count) {
            this.parent.onSuccess();
        }
    }

    @Override
    public void onFail() {
        this.parent.onFail();
    }
}

