/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.blockentity;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class AlbumJukeboxBlockEntity
extends class_2621
implements class_1278 {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private class_2371<class_1799> items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    private int playingIndex = -1;
    private int track = 0;
    private class_1799 playingStack = class_1799.field_8037;
    private boolean loaded;

    public AlbumJukeboxBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EtchedBlocks.ALBUM_JUKEBOX_BE.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AlbumJukeboxBlockEntity entity) {
        if (level == null || !level.method_8608()) {
            return;
        }
        if (!entity.loaded) {
            entity.loaded = true;
            SoundTracker.playAlbum(entity, state, (class_638)level, pos, false);
        }
        if (entity.isPlaying()) {
            class_238 range = new class_238(pos).method_1014(3.45);
            List livingEntities = level.method_18467(class_1309.class, range);
            livingEntities.forEach(living -> living.method_6006(pos, true));
        }
    }

    private void updateState() {
        if (this.field_11863 != null) {
            boolean hasRecord;
            boolean hasItem = false;
            for (class_1799 stack : this.method_11282()) {
                if (stack == class_1799.field_8037) continue;
                hasItem = true;
                break;
            }
            if (hasItem != (hasRecord = ((Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AlbumJukeboxBlock.HAS_RECORD)).booleanValue())) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)AlbumJukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasItem)), 3);
                this.method_5431();
            }
        }
    }

    private void updatePlaying() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.items);
        }
        if (this.loaded) {
            SoundTracker.playAlbum(this, this.method_11010(), (class_638)this.field_11863, this.method_11016(), false);
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.method_11286(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.items);
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] method_5494(class_2350 direction) {
        return SLOTS;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return PlayableRecord.isPlayableRecord(stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public int method_5439() {
        return 9;
    }

    public class_1799 method_5434(int index, int amount) {
        class_1799 stack = super.method_5434(index, amount);
        this.updateState();
        if (!stack.method_7960()) {
            this.updatePlaying();
        }
        return stack;
    }

    public class_1799 method_5441(int index) {
        class_1799 stack = super.method_5441(index);
        this.updateState();
        if (!stack.method_7960()) {
            this.updatePlaying();
        }
        return stack;
    }

    public void method_5447(int index, class_1799 stack) {
        super.method_5447(index, stack);
        this.updateState();
        this.updatePlaying();
    }

    public void method_5448() {
        super.method_5448();
        this.updateState();
        this.updatePlaying();
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> nonNullList) {
        this.items = nonNullList;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.etched.album_jukebox");
    }

    protected class_1703 method_5465(int menuId, class_1661 inventory) {
        return new AlbumJukeboxMenu(menuId, inventory, (class_1263)this, this.method_11016());
    }

    public int method_5444() {
        return 1;
    }

    public int getPlayingIndex() {
        return this.playingIndex;
    }

    public int getTrack() {
        return this.track;
    }

    public boolean setPlayingIndex(int playingIndex, int track) {
        this.playingIndex = playingIndex;
        this.track = track;
        if (this.recalculatePlayingIndex(false)) {
            int tracks = PlayableRecord.getStackTrackCount(this.playingStack);
            if (this.track >= tracks) {
                this.track = 0;
            }
            return true;
        }
        return false;
    }

    public void stopPlaying() {
        this.playingIndex = -1;
        this.track = 0;
        this.playingStack = class_1799.field_8037;
    }

    public void previous() {
        if (this.track > 0) {
            --this.track;
        } else {
            --this.playingIndex;
            if (this.playingIndex < 0) {
                this.playingIndex = this.method_5439() - 1;
            }
            this.nextPlayingIndex(true);
            this.track = Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.method_5439() ? 0 : PlayableRecord.getStackTrackCount(this.method_5438(this.playingIndex)) - 1);
            this.playingStack = class_1799.field_8037;
        }
    }

    public void next() {
        int tracks;
        int n = tracks = this.playingIndex < 0 || this.playingIndex >= this.method_5439() ? 1 : PlayableRecord.getStackTrackCount(this.method_5438(this.playingIndex));
        if (this.track < tracks - 1) {
            ++this.track;
        } else {
            ++this.playingIndex;
            this.playingIndex %= this.method_5439();
            this.nextPlayingIndex(false);
            this.track = 0;
            this.playingStack = class_1799.field_8037;
        }
    }

    public void nextPlayingIndex(boolean reverse) {
        boolean wrap = false;
        this.playingIndex = class_3532.method_15340((int)this.playingIndex, (int)0, (int)(this.method_5439() - 1));
        while (!PlayableRecord.isPlayableRecord(this.method_5438(this.playingIndex))) {
            if (reverse) {
                --this.playingIndex;
                if (this.playingIndex >= 0) continue;
                this.playingIndex = this.method_5439() - 1;
                if (wrap) {
                    this.playingIndex = -1;
                    this.track = 0;
                    this.playingStack = class_1799.field_8037;
                    return;
                }
                wrap = true;
                continue;
            }
            ++this.playingIndex;
            if (this.playingIndex < this.method_5439()) continue;
            this.playingIndex = 0;
            if (wrap) {
                this.playingIndex = -1;
                this.track = 0;
                this.playingStack = class_1799.field_8037;
                return;
            }
            wrap = true;
        }
        this.playingStack = this.method_5438(this.playingIndex).method_7972();
    }

    public boolean recalculatePlayingIndex(boolean reverse) {
        if (this.method_5442()) {
            if (this.playingIndex == -1) {
                return false;
            }
            this.playingIndex = -1;
            this.track = 0;
            return true;
        }
        int oldIndex = this.playingIndex;
        class_1799 oldStack = this.playingStack.method_7972();
        this.nextPlayingIndex(reverse);
        if (oldIndex != this.playingIndex || !class_1799.method_7973((class_1799)oldStack, (class_1799)this.playingStack)) {
            this.track = reverse ? Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.method_5439() ? 0 : PlayableRecord.getStackTrackCount(this.method_5438(this.playingIndex)) - 1) : 0;
            return true;
        }
        return false;
    }

    public boolean isPlaying() {
        class_2680 state = this.method_11010();
        return (!state.method_28498((class_2769)AlbumJukeboxBlock.POWERED) || (Boolean)state.method_11654((class_2769)AlbumJukeboxBlock.POWERED) == false) && !this.method_5442();
    }
}

