/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.handler.EtchedClientPlayPacketHandler;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.pollen.api.network.v1.packet.PollinatedPacketContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandlerImpl
implements EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        class_2338 pos = pkt.getPos();
        class_1113 soundInstance = playingRecords.get(pos);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                soundManager.method_4870(soundInstance);
                playingRecords.remove(pos);
            }
            if (pkt.getTracks().length == 0) {
                return;
            }
            SoundTracker.playBlockRecord(pos, pkt.getTracks(), 0);
        });
    }

    @Override
    public void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        class_1144 soundManager = class_310.method_1551().method_1483();
        class_1113 soundInstance = SoundTracker.getEntitySound(entityId);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                if (soundInstance instanceof StopListeningSound) {
                    ((StopListeningSound)soundInstance).stopListening();
                }
                if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && soundManager.method_4877(soundInstance)) {
                    return;
                }
                SoundTracker.setEntitySound(entityId, null);
            }
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
                return;
            }
            class_1297 entity = level.method_8469(entityId);
            if (entity == null) {
                LOGGER.error("Server sent sound for nonexistent entity: " + entityId);
                return;
            }
            class_1799 record = pkt.getRecord();
            if (!PlayableRecord.isPlayableRecord(record)) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            Optional<? extends class_1113> sound = ((PlayableRecord)record.method_7909()).createEntitySound(record, entity, 0);
            if (!sound.isPresent()) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> class_310.method_1551().method_18858(() -> {
                SoundTracker.setEntitySound(entityId, null);
                SoundTracker.playEntityRecord(record, entityId, 1, false);
            }));
            SoundTracker.setEntitySound(entityId, entitySound);
        });
    }

    @Override
    public void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (class_310.method_1551().field_1755 instanceof EtchingScreen) {
                EtchingScreen screen = (EtchingScreen)class_310.method_1551().field_1755;
                screen.setReason(pkt.getException());
            }
        });
    }

    @Override
    public void handleSetUrl(ClientboundSetUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (class_310.method_1551().field_1755 instanceof RadioScreen) {
                RadioScreen screen = (RadioScreen)class_310.method_1551().field_1755;
                screen.receiveUrl(pkt.getUrl());
            }
        });
    }

    @Override
    public void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, PollinatedPacketContext ctx) {
        class_310 minecraft = class_310.method_1551();
        ctx.enqueueWork(() -> {
            if (minecraft.field_1687 != null && minecraft.field_1755 instanceof AlbumJukeboxScreen) {
                AlbumJukeboxScreen screen = (AlbumJukeboxScreen)minecraft.field_1755;
                class_2338 pos = ((AlbumJukeboxMenu)screen.method_17577()).getPos();
                if (((AlbumJukeboxMenu)screen.method_17577()).setPlayingTrack((class_1937)minecraft.field_1687, pkt)) {
                    AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(minecraft.field_1687.method_8321(pos));
                    SoundTracker.playAlbum(entity, entity.method_11010(), minecraft.field_1687, pos, true);
                }
            }
        });
    }
}

