/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.sound.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.M3uParser;
import gg.moonflower.etched.api.util.ProgressTrackingInputStream;
import gg.moonflower.etched.common.sound.download.SoundCloudIdTracker;
import gg.moonflower.etched.common.sound.download.SourceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SoundCloudSource
implements SoundDownloadSource {
    static final Logger LOGGER = LogManager.getLogger();
    private static final class_2561 BRAND = class_2561.method_43471((String)"sound_source.etched.sound_cloud").method_27694(style -> style.method_27703(class_5251.method_27717((int)0xFF5500)));
    private final Map<String, Boolean> validCache = new WeakHashMap<String, Boolean>();

    private static URL appendUri(String uri, String appendQuery) throws Exception {
        URI oldUri = new URI(uri);
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)(oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery), oldUri.getFragment()).toURL();
    }

    private InputStream get(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, int attempt, boolean requiresId) throws IOException {
        if (progressListener != null) {
            progressListener.progressStartRequest((class_2561)class_2561.method_43469((String)"sound_source.etched.requesting", (Object[])new Object[]{this.getApiName()}));
        }
        try {
            URL uRL = requiresId ? SoundCloudSource.appendUri(url, "client_id=" + SoundCloudIdTracker.fetch(proxy)) : new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            int response = httpURLConnection.getResponseCode();
            if (requiresId && attempt == 0 && (response == 401 || response == 403)) {
                LOGGER.info("Attempting to authenticate");
                SoundCloudIdTracker.invalidate();
                return this.get(url, progressListener, proxy, 1, true);
            }
            long size = httpURLConnection.getContentLengthLong();
            if (response != 200) {
                System.out.println(httpURLConnection);
                throw new IOException(response + " " + httpURLConnection.getResponseMessage());
            }
            return size != -1L && progressListener != null ? new ProgressTrackingInputStream(httpURLConnection.getInputStream(), size, progressListener) : httpURLConnection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private <T> T resolve(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, SourceRequest<T> function) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(this.get("https://api-v2.soundcloud.com/resolve?url=" + URLEncoder.encode(url, StandardCharsets.UTF_8), progressListener, proxy, 0, true));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String kind = class_3518.method_15265((JsonObject)json, (String)"kind");
            if (!"track".equals(kind) && !"playlist".equals(kind)) {
                throw new IOException("URL is not a track or album");
            }
            if ("track".equals(kind) && !class_3518.method_15270((JsonObject)json, (String)"streamable")) {
                throw new IOException("URL is not streamable");
            }
            if ("playlist".equals(kind) && !class_3518.method_15270((JsonObject)json, (String)"is_album")) {
                throw new IOException("URL is not a track or album");
            }
            T t = function.process(json);
            return t;
        }
    }

    @Override
    public List<URL> resolveUrl(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException {
        return this.resolve(url, progressListener, proxy, json -> {
            if (progressListener != null) {
                progressListener.progressStartRequest(RESOLVING_TRACKS);
            }
            JsonArray media = class_3518.method_15261((JsonObject)class_3518.method_15296((JsonObject)json, (String)"media"), (String)"transcodings");
            int progressiveIndex = -1;
            for (int i = 0; i < media.size(); ++i) {
                JsonObject transcodingJson = class_3518.method_15295((JsonElement)media.get(i), (String)("transcodings[" + i + "]"));
                JsonObject format = transcodingJson.getAsJsonObject("format");
                String protocol = format.get("protocol").getAsString();
                if ("progressive".equals(protocol)) {
                    progressiveIndex = i;
                }
                if (!"hls".equals(protocol)) continue;
                try (InputStreamReader urlReader = new InputStreamReader(this.get(class_3518.method_15265((JsonObject)transcodingJson, (String)"url"), null, proxy, 0, true));){
                    List<URL> list;
                    try (InputStreamReader reader = new InputStreamReader(this.get(class_3518.method_15265((JsonObject)JsonParser.parseReader((Reader)urlReader).getAsJsonObject(), (String)"url"), null, proxy, 0, false));){
                        list = M3uParser.parse(reader);
                    }
                    return list;
                }
            }
            if (progressiveIndex == -1) {
                throw new IOException("Could not find an audio source");
            }
            try (InputStreamReader reader = new InputStreamReader(this.get(class_3518.method_15265((JsonObject)class_3518.method_15295((JsonElement)media.get(progressiveIndex), (String)("transcodings[" + progressiveIndex + "]")), (String)"url"), null, proxy, 0, true));){
                List<URL> list = Collections.singletonList(new URL(class_3518.method_15265((JsonObject)JsonParser.parseReader((Reader)reader).getAsJsonObject(), (String)"url")));
                return list;
            }
        });
    }

    @Override
    public TrackData[] resolveTracks(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            JsonObject user = class_3518.method_15296((JsonObject)json, (String)"user");
            String artist = class_3518.method_15265((JsonObject)user, (String)"username");
            String title = class_3518.method_15265((JsonObject)json, (String)"title");
            String kind = class_3518.method_15265((JsonObject)json, (String)"kind");
            if ("playlist".equals(kind)) {
                JsonArray tracksJson = class_3518.method_15261((JsonObject)json, (String)"tracks");
                ArrayList<TrackData> tracks = new ArrayList<TrackData>();
                tracks.add(new TrackData(url, artist, (class_2561)class_2561.method_43470((String)title)));
                for (int i = 0; i < tracksJson.size(); ++i) {
                    try {
                        JsonObject trackJson = class_3518.method_15295((JsonElement)tracksJson.get(i), (String)("tracks[" + i + "]"));
                        if (!trackJson.has("permalink_url")) continue;
                        JsonObject trackUser = class_3518.method_15281((JsonObject)trackJson, (String)"user", (JsonObject)user);
                        String trackUrl = class_3518.method_15265((JsonObject)trackJson, (String)"permalink_url");
                        String trackArtist = class_3518.method_15265((JsonObject)trackUser, (String)"username");
                        String trackTitle = class_3518.method_15265((JsonObject)trackJson, (String)"title");
                        tracks.add(new TrackData(trackUrl, trackArtist, (class_2561)class_2561.method_43470((String)trackTitle)));
                        continue;
                    }
                    catch (JsonParseException e) {
                        LOGGER.error("Failed to parse track: " + url + "[" + i + "]", (Throwable)e);
                    }
                }
                return tracks.toArray(new TrackData[0]);
            }
            return new TrackData[]{new TrackData(url, artist, (class_2561)class_2561.method_43470((String)title))};
        });
    }

    @Override
    public Optional<String> resolveAlbumCover(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, class_3300 resourceManager) throws IOException {
        return this.resolve(url, progressListener, proxy, json -> {
            if (!json.has("artwork_url") || json.get("artwork_url").isJsonNull()) {
                return Optional.empty();
            }
            return Optional.of(class_3518.method_15265((JsonObject)json, (String)"artwork_url"));
        });
    }

    @Override
    public boolean isValidUrl(String url) {
        return this.validCache.computeIfAbsent(url, key -> {
            try {
                String host = new URI((String)key).getHost();
                return "soundcloud.com".equals(host);
            }
            catch (URISyntaxException e) {
                return false;
            }
        });
    }

    @Override
    public boolean isTemporary(String url) {
        return true;
    }

    @Override
    public String getApiName() {
        return "SoundCloud";
    }

    @Override
    public Optional<class_2561> getBrandText(String url) {
        return Optional.of(BRAND);
    }
}

