/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.client.render.entity.VillagerAnimation;
import gg.moonflower.etched.core.hook.VillagerExtension;
import gg.moonflower.etched.core.util.AnimationUtil;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.pinwheel.api.animation.AnimationData;
import gg.moonflower.pinwheel.api.animation.PlayingAnimation;
import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryModelManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_620;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_620.class})
public abstract class VillagerModelMixin<T extends class_1297> {
    @Unique
    private static final class_2960 MODEL_LOCATION = new class_2960("etched", "villager");
    @Unique
    private static final MolangEnvironment ENVIRONMENT = MolangRuntime.runtime().create();
    @Unique
    private static final PlayingAnimation ANIMATION = new VillagerAnimation();
    @Unique
    private static final Set<String> USED_BONES = new HashSet<String>();
    @Unique
    private static final Map<String, class_5603> ORIGINS = new HashMap<String, class_5603>();
    @Shadow
    @Final
    private class_630 field_27526;

    @Shadow
    public abstract class_630 method_32008();

    @Unique
    private class_5603 getOrigin(String name) {
        return ORIGINS.computeIfAbsent(name, s -> this.method_32008().method_32086(name).method_32084());
    }

    @Unique
    private void reset(class_630 part, String name) {
        part.method_32085(this.getOrigin(name));
    }

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void reset(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension)) {
            return;
        }
        this.reset(this.field_27526.method_32086("head"), "head");
        this.reset(this.field_27526.method_32086("body"), "body");
        this.reset(this.field_27526.method_32086("arms"), "arms");
        this.reset(this.field_27526.method_32086("left_leg"), "left_leg");
        this.reset(this.field_27526.method_32086("right_leg"), "right_leg");
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void animate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        VillagerExtension ext;
        if (!(entity instanceof VillagerExtension) || !(ext = (VillagerExtension)entity).isDancing()) {
            return;
        }
        GeometryModel model = GeometryModelManager.getModel((class_2960)MODEL_LOCATION);
        if (model == GeometryModel.EMPTY) {
            return;
        }
        ANIMATION.setAnimationTime(ageInTicks / 20.0f);
        model.applyAnimations(ENVIRONMENT, List.of(ANIMATION));
        USED_BONES.clear();
        for (AnimationData.BoneAnimation boneAnimation : ANIMATION.getAnimation().boneAnimations()) {
            USED_BONES.add(boneAnimation.name());
        }
        USED_BONES.forEach(s -> AnimationUtil.copyAngles(s, model, this.method_32008().method_32086(s)));
        USED_BONES.clear();
    }
}

