/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.architectury.registry.registries.RegistrySupplier;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.pollen.api.event.entity.v1.ModifyTradesEvents;
import gg.moonflower.pollen.api.registry.wrapper.v1.PollinatedVillagerRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3815;
import net.minecraft.class_3834;
import net.minecraft.class_3836;
import net.minecraft.class_3852;
import net.minecraft.class_3868;
import net.minecraft.class_3870;
import net.minecraft.class_4158;
import net.minecraft.class_5458;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_6880;

public class EtchedVillagers {
    public static final PollinatedVillagerRegistry REGISTRY = PollinatedVillagerRegistry.create((String)"etched");
    public static final RegistrySupplier<class_4158> BARD_POI = REGISTRY.registerPoiType("bard", () -> new class_4158((Set)ImmutableSet.builder().addAll((Iterable)class_2246.field_10179.method_9595().method_11662()).build(), 1, 1));
    public static final RegistrySupplier<class_3852> BARD = REGISTRY.register("bard", () -> new class_3852("etched:bard", poi -> poi.method_40226(BARD_POI.getId()), poi -> poi.method_40226(BARD_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), null));

    public static void registerVillages() {
        class_3815.method_16754();
        class_3868.method_17037();
        class_3834.method_16844();
        class_3836.method_16845();
        class_3870.method_17038();
        EtchedVillagers.createVillagePiece("plains", "bard_house", 1, 2, (class_6880<class_5497>)class_5469.field_26264, (class_6880<class_5497>)class_5469.field_26259);
        EtchedVillagers.createVillagePiece("desert", "bard_house", 1, 2, (class_6880<class_5497>)class_5469.field_26263);
        EtchedVillagers.createVillagePiece("savanna", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26260);
        EtchedVillagers.createVillagePiece("snowy", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26261);
        EtchedVillagers.createVillagePiece("taiga", "bard_house", 1, 4, (class_6880<class_5497>)class_5469.field_26264, (class_6880<class_5497>)class_5469.field_26262);
    }

    public static void registerTrades() {
        ModifyTradesEvents.VILLAGER.register(context -> {
            if (context.getProfession() != BARD.get()) {
                return;
            }
            ModifyTradesEvents.TradeRegistry tier1 = context.getTrades(1);
            tier1.add((class_1935)class_1802.field_8144, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8731, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8075, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_35358, 8, 1, 4, 20, true);
            tier1.add((class_1935)class_1802.field_8643, 1, 2, 16, 2, true);
            tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
            ModifyTradesEvents.TradeRegistry tier2 = context.getTrades(2);
            tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
            tier2.add(EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
            ModifyTradesEvents.TradeRegistry tier3 = context.getTrades(3);
            tier3.add((class_1935)class_2246.field_10460, 6, 1, 16, 2, false);
            tier3.add((class_1935)class_2246.field_10359, 12, 1, 8, 2, false);
            tier3.add((class_1935)class_2246.field_10446, 8, 1, 32, 4, false);
            tier3.add((class_1935)class_2246.field_10166, 24, 1, 8, 4, false);
            tier3.add((class_1935)class_2246.field_10225, 36, 1, 4, 8, false);
            tier3.add((class_1935)class_2246.field_10205, 48, 1, 2, 10, false);
            ModifyTradesEvents.TradeRegistry tier4 = context.getTrades(4);
            tier3.add((class_1935)class_1802.field_8565, 26, 1, 4, 30, false);
            tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
            tier4.add(EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
            ModifyTradesEvents.TradeRegistry tier5 = context.getTrades(5);
            tier5.add((class_1935)class_1802.field_8477, 8, 1, 8, 40, true);
            tier5.add((class_1935)class_1802.field_27063, 1, 8, 10, 40, true);
            class_2378.field_11142.method_40266(class_3489.field_15541).ifPresent(tag -> tag.method_40239().forEach(item -> tier5.add((class_1935)item.comp_349(), 10, 1, 4, 40, true)));
        });
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, class_6880<class_5497> zombieProcessor) {
        EtchedVillagers.createVillagePiece(village, name, houseId, weight, (class_6880<class_5497>)class_5469.field_26688, zombieProcessor);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, class_6880<class_5497> normalProcessor, class_6880<class_5497> zombieProcessor) {
        EtchedVillagers.addToPool(new class_2960("village/" + village + "/houses"), new class_2960("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), normalProcessor, weight);
        EtchedVillagers.addToPool(new class_2960("village/" + village + "/zombie/houses"), new class_2960("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), zombieProcessor, weight);
    }

    private static void addToPool(class_2960 poolId, class_2960 pieceId, class_6880<class_5497> processorList, int weight) {
        class_3785 pool = (class_3785)class_5458.field_25932.method_10223(poolId);
        if (pool == null) {
            return;
        }
        class_3784 piece = (class_3784)class_3784.method_30426((String)pieceId.toString(), processorList).apply(class_3785.class_3786.field_16687);
        ObjectArrayList<class_3784> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        List<Pair<class_3784, Integer>> rawTemplates = ((StructureTemplatePoolAccessor)pool).getRawTemplates();
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
        rawTemplates.add((Pair<class_3784, Integer>)Pair.of((Object)piece, (Object)weight));
    }
}

