/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.client.render.item.ImageAlbumCover;
import gg.moonflower.etched.client.render.item.ModelAlbumCover;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.codec.digest.DigestUtils;

public class AlbumCoverItemRenderer
extends SimplePreparableReloadListener<CoverData>
implements DynamicItemRenderer,
PollinatedPreparableReloadListener {
    public static final AlbumCoverItemRenderer INSTANCE = new AlbumCoverItemRenderer();
    public static final String FOLDER_NAME = "etched_album_cover";
    private static final ModelResourceLocation BLANK_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/blank"), "inventory");
    private static final ModelResourceLocation DEFAULT_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/default"), "inventory");
    private static final ResourceLocation ALBUM_COVER_OVERLAY = new ResourceLocation("etched", "textures/item/album_cover_overlay.png");
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final BlockModel MODEL = BlockModel.m_111463_((String)"{\"gui_light\":\"front\",\"textures\":{\"layer0\":\"texture\"},\"display\":{\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,2,0],\"scale\":[0.5,0.5,0.5]},\"head\":{\"rotation\":[0,180,0],\"translation\":[0,13,7],\"scale\":[1,1,1]},\"thirdperson_righthand\":{\"rotation\":[0,0,0],\"translation\":[0,3,1],\"scale\":[0.55,0.55,0.55]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[0.68,0.68,0.68]},\"fixed\":{\"rotation\":[0,180,0],\"scale\":[1,1,1]}}}");
    private final Map<CompoundTag, CompletableFuture<ModelData>> covers = new HashMap<CompoundTag, CompletableFuture<ModelData>>();
    private CoverData data = null;

    private AlbumCoverItemRenderer() {
    }

    public static void init() {
        ResourceRegistry.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PollinatedPreparableReloadListener)INSTANCE);
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> INSTANCE.close());
    }

    public static NativeImage getOverlayImage() {
        return AlbumCoverItemRenderer.INSTANCE.data.overlay.getImage();
    }

    private static void renderModelLists(BakedModel model, int combinedLight, int combinedOverlay, PoseStack matrixStack, VertexConsumer buffer) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.m_6840_(null, direction, random), combinedLight, combinedOverlay);
        }
        random.setSeed(42L);
        AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.m_6840_(null, null, random), combinedLight, combinedOverlay);
    }

    private static void renderQuadList(PoseStack matrixStack, VertexConsumer buffer, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        for (BakedQuad bakedQuad : quads) {
            buffer.m_85987_(pose, bakedQuad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
    }

    private static NativeImage getCoverOverlay(ResourceManager resourceManager) {
        NativeImage nativeImage;
        block11: {
            Resource resource = resourceManager.m_142591_(ALBUM_COVER_OVERLAY);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)resource.m_6679_());
                if (resource == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    NativeImage nativeImage2 = new NativeImage(16, 16, false);
                    for (int k = 0; k < 16; ++k) {
                        for (int l = 0; l < 16; ++l) {
                            if (k < 8 ^ l < 8) {
                                nativeImage2.m_84988_(l, k, -524040);
                                continue;
                            }
                            nativeImage2.m_84988_(l, k, -16777216);
                        }
                    }
                    nativeImage2.m_85123_();
                    return nativeImage2;
                }
            }
            resource.close();
        }
        return nativeImage;
    }

    private void close() {
        this.covers.values().forEach(future -> future.thenAcceptAsync(data -> {
            if (!this.data.is((ModelData)data)) {
                data.close();
            }
        }, task -> RenderSystem.m_69879_(task::run)));
        this.covers.clear();
    }

    protected CoverData prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return new CoverData(AlbumCoverItemRenderer.getCoverOverlay(resourceManager));
    }

    protected void apply(CoverData data, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (this.data != null) {
            this.data.close();
        }
        this.data = data;
        this.close();
    }

    public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
        if (stack.m_41619_()) {
            return;
        }
        ModelData model = stack.m_41737_("CoverRecord") == null ? this.data.blank : this.covers.computeIfAbsent(stack.m_41737_("CoverRecord"), __ -> {
            ItemStack coverStack = AlbumCoverItem.getCoverStack(stack).orElse(ItemStack.f_41583_);
            if (!coverStack.m_41619_() && coverStack.m_41720_() instanceof PlayableRecord) {
                return ((CompletableFuture)((PlayableRecord)coverStack.m_41720_()).getAlbumCover(coverStack, Minecraft.m_91087_().m_91096_(), Minecraft.m_91087_().m_91098_()).thenApply(cover -> ModelData.of(cover).orElse(this.data.defaultCover))).exceptionally(e -> {
                    e.printStackTrace();
                    return this.data.defaultCover;
                });
            }
            return CompletableFuture.completedFuture(this.data.blank);
        }).getNow(this.data.defaultCover);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        model.render(stack, transformType, matrixStack, buffer, packedLight, combinedOverlay);
        matrixStack.m_85849_();
    }

    public ResourceLocation getPollenId() {
        return new ResourceLocation("etched", "builtin_album_cover");
    }

    public static class CoverData {
        private final DynamicModelData overlay;
        private final ModelData blank;
        private final ModelData defaultCover;

        private CoverData(NativeImage overlay) {
            this.overlay = new DynamicModelData(overlay);
            this.blank = new BakedModelData(BLANK_ALBUM_COVER);
            this.defaultCover = new BakedModelData(DEFAULT_ALBUM_COVER);
        }

        public void close() {
            this.overlay.close();
            this.blank.close();
            this.defaultCover.close();
        }

        public boolean is(ModelData data) {
            return this.overlay == data || this.blank == data || this.defaultCover == data;
        }
    }

    private static class DynamicModelData
    extends TextureAtlasSprite
    implements ModelData {
        private static final TextureAtlas ATLAS = new TextureAtlas(new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())));
        private BakedModel model;

        private DynamicModelData(NativeImage image) {
            super(ATLAS, new TextureAtlasSprite.Info(new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())), image.m_84982_(), image.m_85084_(), AnimationMetadataSection.f_119012_), 0, image.m_84982_(), image.m_85084_(), 0, 0, image);
        }

        @Override
        public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
            BakedModel model = this.getModel();
            if (model.m_7521_()) {
                return;
            }
            model.m_7442_().m_111808_(transformType).m_111763_(transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, matrixStack);
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            AlbumCoverItemRenderer.renderModelLists(model, packedLight, combinedOverlay, matrixStack, ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)RenderType.m_110452_((ResourceLocation)this.m_118413_()), (boolean)false, (boolean)stack.m_41790_()));
        }

        private BakedModel getModel() {
            if (this.model == null) {
                ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
                profiler.m_6180_("buildAlbumCoverModel");
                this.model = ITEM_MODEL_GENERATOR.m_111670_(material -> this, MODEL).m_111449_(null, MODEL, material -> this, (ModelState)BlockModelRotation.X0_Y0, this.m_118413_(), false);
                profiler.m_7238_();
            }
            if (Minecraft.m_91087_().m_91097_().m_174786_(this.m_118413_(), null) == null) {
                Minecraft.m_91087_().m_91097_().m_118495_(this.m_118413_(), (AbstractTexture)new DynamicTexture(this.f_118342_[0]));
            }
            return this.model;
        }

        public NativeImage getImage() {
            return this.f_118342_[0];
        }

        public float m_118417_() {
            return 0.0f;
        }

        public VertexConsumer m_118381_(VertexConsumer buffer) {
            return buffer;
        }

        @Override
        public void close() {
            super.close();
            Minecraft.m_91087_().m_91097_().m_118513_(this.m_118413_());
        }
    }

    private static interface ModelData {
        public static Optional<ModelData> of(AlbumCover cover) {
            if (cover instanceof ModelAlbumCover) {
                return Optional.of(new BakedModelData(((ModelAlbumCover)cover).getModel()));
            }
            if (cover instanceof ImageAlbumCover) {
                return Optional.of(new DynamicModelData(((ImageAlbumCover)cover).getImage()));
            }
            return Optional.empty();
        }

        public void render(ItemStack var1, ItemTransforms.TransformType var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

        public void close();
    }

    private static class BakedModelData
    implements ModelData {
        private final ModelResourceLocation model;
        private boolean rendering;

        private BakedModelData(ModelResourceLocation model) {
            this.model = model;
        }

        @Override
        public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            BakedModel model = this.rendering ? modelManager.m_119409_() : modelManager.m_119422_(this.model);
            this.rendering = true;
            Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, matrixStack, buffer, packedLight, combinedOverlay, model);
            this.rendering = false;
        }

        @Override
        public void close() {
        }
    }
}

