/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EditMusicLabelScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("etched", "textures/gui/edit_music_label.png");
    private static final ResourceLocation LABEL = new ResourceLocation("etched", "textures/gui/label.png");
    private static final TranslatableComponent TITLE_COMPONENT = new TranslatableComponent("screen.etched.edit_music_label.title");
    private static final TranslatableComponent AUTHOR_COMPONENT = new TranslatableComponent("screen.etched.edit_music_label.author");
    private final Player player;
    private final InteractionHand hand;
    private final ItemStack labelStack;
    private final int imageWidth = 176;
    private final int imageHeight = 139;
    private Button doneButton;
    private EditBox title;
    private EditBox author;

    public EditMusicLabelScreen(Player player, InteractionHand hand, ItemStack stack) {
        super(NarratorChatListener.f_93310_);
        this.player = player;
        this.hand = hand;
        this.labelStack = stack;
    }

    protected void m_7856_() {
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.f_96541_.f_91068_.m_90926_(true);
        this.doneButton = new Button(leftPos, topPos + this.imageHeight + 5, this.imageWidth, 20, CommonComponents.f_130655_, button -> {
            this.saveChanges();
            this.f_96541_.m_91152_(null);
        });
        this.m_142416_((GuiEventListener)this.doneButton);
        this.title = new EditBox(this.f_96547_, leftPos + 10, topPos + 91, 154, 10, (Component)TITLE_COMPONENT);
        this.title.m_94144_(SimpleMusicLabelItem.getTitle(this.labelStack));
        this.title.m_94205_(-1);
        this.title.m_94202_(-1);
        this.title.m_94199_(128);
        this.title.m_94182_(false);
        this.title.m_94190_(true);
        this.title.m_94178_(true);
        this.m_7522_((GuiEventListener)this.title);
        this.author = new EditBox(this.f_96547_, leftPos + 10, topPos + 121, 154, 10, (Component)AUTHOR_COMPONENT);
        this.author.m_94144_(SimpleMusicLabelItem.getAuthor(this.labelStack));
        this.author.m_94205_(-1);
        this.author.m_94202_(-1);
        this.author.m_94199_(128);
        this.author.m_94182_(false);
        this.author.m_94190_(true);
        this.title.m_94151_(string -> {
            if ((this.author.m_94155_().isEmpty() || string.isEmpty()) && this.doneButton.f_93623_) {
                this.doneButton.f_93623_ = false;
            } else if (!(this.author.m_94155_().isEmpty() || string.isEmpty() || this.doneButton.f_93623_)) {
                this.doneButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.title);
        this.author.m_94151_(string -> {
            if ((this.title.m_94155_().isEmpty() || string.isEmpty()) && this.doneButton.f_93623_) {
                this.doneButton.f_93623_ = false;
            } else if (!(this.title.m_94155_().isEmpty() || string.isEmpty() || this.doneButton.f_93623_)) {
                this.doneButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.author);
    }

    public void m_6574_(Minecraft minecraft, int i, int j) {
        String title = this.title.m_94155_();
        String author = this.author.m_94155_();
        boolean titleFocused = this.title.m_93696_();
        boolean authorFocused = this.author.m_93696_();
        GuiEventListener focused = this.m_7222_();
        this.m_6575_(minecraft, i, j);
        this.title.m_94144_(title);
        this.title.m_94178_(titleFocused);
        this.author.m_94144_(author);
        this.author.m_94178_(authorFocused);
        this.m_7522_(focused);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_96624_() {
        this.title.m_94120_();
        this.author.m_94120_();
    }

    protected void renderBg(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int primaryLabelColor;
        this.m_7333_(poseStack);
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.f_96547_.m_92889_(poseStack, (Component)TITLE_COMPONENT, (float)(leftPos + 7), (float)(topPos + 77), 0x404040);
        this.f_96547_.m_92889_(poseStack, (Component)AUTHOR_COMPONENT, (float)(leftPos + 7), (float)(topPos + 77 + 30), 0x404040);
        int secondaryLabelColor = primaryLabelColor = 0xFFFFFF;
        if (this.labelStack.m_41720_() instanceof MusicLabelItem) {
            secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(this.labelStack);
        } else if (this.labelStack.m_41720_() instanceof ComplexMusicLabelItem) {
            primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(this.labelStack);
            secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(this.labelStack);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)LABEL);
        RenderSystem.m_157429_((float)((float)(primaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        this.m_93228_(poseStack, leftPos, topPos, 0, 0, this.imageWidth, 70);
        RenderSystem.m_157429_((float)((float)(secondaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        this.m_93228_(poseStack, leftPos, topPos, 0, 70, this.imageWidth, 70);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBg(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void saveChanges() {
        String author = this.author.m_94155_().trim();
        String title = this.title.m_94155_().trim();
        SimpleMusicLabelItem.setTitle(this.labelStack, title);
        SimpleMusicLabelItem.setAuthor(this.labelStack, author);
        int slot = this.hand == InteractionHand.MAIN_HAND ? this.player.m_150109_().f_35977_ : 40;
        EtchedMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundEditMusicLabelPacket(slot, author, title));
    }
}

