/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.menu.EtchingMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ServerboundSetUrlPacket;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.pollen.api.client.render.ShapeRenderer;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class EtchingScreen
extends AbstractContainerScreen<EtchingMenu>
implements ContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("etched", "textures/gui/container/etching_table.png");
    private static final Component INVALID_URL = new TranslatableComponent("screen.etched.etching_table.error.invalid_url");
    private static final Component CANNOT_CREATE = new TranslatableComponent("screen.etched.etching_table.error.cannot_create");
    private static final Component CANNOT_CREATE_MISSING_DISC = new TranslatableComponent("screen.etched.etching_table.error.cannot_create.missing_disc").m_130940_(ChatFormatting.GRAY);
    private static final Component CANNOT_CREATE_MISSING_LABEL = new TranslatableComponent("screen.etched.etching_table.error.cannot_create.missing_label").m_130940_(ChatFormatting.GRAY);
    private ItemStack discStack;
    private ItemStack labelStack;
    private EditBox url;
    private int urlTicks;
    private String oldUrl;
    private String invalidReason;
    private boolean displayLabels;

    public EtchingScreen(EtchingMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.f_97727_ = 180;
        this.f_97731_ += 14;
        this.discStack = ItemStack.f_41583_;
        this.labelStack = ItemStack.f_41583_;
        this.invalidReason = "";
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.url = new EditBox(this.f_96547_, this.f_97735_ + 11, this.f_97736_ + 25, 154, 16, this.url, (Component)new TranslatableComponent("container.etched.etching_table.url"));
        this.url.m_94202_(-1);
        this.url.m_94205_(-1);
        this.url.m_94182_(false);
        this.url.m_94199_(32500);
        this.url.m_94151_(s -> {
            if (!Objects.equals(this.oldUrl, s) && this.urlTicks <= 0) {
                EtchedMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundSetUrlPacket(""));
            }
            this.urlTicks = 8;
        });
        this.url.m_94190_(true);
        this.m_7787_((GuiEventListener)this.url);
        ((EtchingMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_181908_() {
        this.url.m_94120_();
        if (this.urlTicks > 0) {
            --this.urlTicks;
            if (this.urlTicks <= 0 && !Objects.equals(this.oldUrl, this.url.m_94155_())) {
                this.oldUrl = this.url.m_94155_();
                EtchedMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundSetUrlPacket(this.url.m_94155_()));
            }
        }
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int slot, ItemStack stack) {
        if (slot == 0) {
            if (this.discStack.m_41619_() && !stack.m_41619_()) {
                this.url.m_94144_("");
            }
            PlayableRecord.getStackAlbum(stack).ifPresent(track -> this.url.m_94144_(track.getUrl()));
            this.discStack = stack;
        }
        if (slot == 1) {
            this.labelStack = stack;
        }
        boolean editable = this.discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get() || !this.discStack.m_41619_() && !this.labelStack.m_41619_();
        this.url.m_94186_(editable);
        this.url.m_94194_(editable);
        this.url.m_94178_(editable);
        this.m_7522_((GuiEventListener)(editable ? this.url : null));
        this.displayLabels = !this.discStack.m_41619_() && !this.labelStack.m_41619_();
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int index, int value) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.url.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        boolean isEtched = this.discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get();
        ArrayList<FormattedCharSequence> reasonLines = new ArrayList<FormattedCharSequence>();
        if (!isEtched && !this.discStack.m_41619_() && this.labelStack.m_41619_()) {
            reasonLines.add(CANNOT_CREATE.m_7532_());
            reasonLines.add(CANNOT_CREATE_MISSING_LABEL.m_7532_());
        } else if (!isEtched && this.discStack.m_41619_() && !this.labelStack.m_41619_()) {
            reasonLines.add(CANNOT_CREATE.m_7532_());
            reasonLines.add(CANNOT_CREATE_MISSING_DISC.m_7532_());
        } else if (!this.url.m_94155_().isEmpty() && !TrackData.isValidURL(this.url.m_94155_()) || !this.invalidReason.isEmpty()) {
            reasonLines.add(INVALID_URL.m_7532_());
            if (!this.invalidReason.isEmpty()) {
                reasonLines.addAll(this.f_96547_.m_92923_((FormattedText)new TextComponent(this.invalidReason).m_130940_(ChatFormatting.GRAY), 200));
            }
        }
        if (mouseX >= this.f_97735_ + 83 && mouseX < this.f_97735_ + 110 && mouseY >= this.f_97736_ + 44 && mouseY < this.f_97736_ + 61) {
            this.m_96617_(poseStack, reasonLines, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack poseStack, float f, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.url.m_94155_().isEmpty() && !TrackData.isValidURL(this.url.m_94155_()) || !this.invalidReason.isEmpty() || this.discStack.m_41720_() != EtchedItems.ETCHED_MUSIC_DISC.get() && (!this.discStack.m_41619_() && this.labelStack.m_41619_() || this.discStack.m_41619_() && !this.labelStack.m_41619_())) {
            this.m_93228_(poseStack, this.f_97735_ + 83, this.f_97736_ + 44, 0, 226, 27, 17);
        }
        this.m_93228_(poseStack, this.f_97735_ + 9, this.f_97736_ + 21, 0, this.discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get() || !this.discStack.m_41619_() && !this.labelStack.m_41619_() ? 180 : 196, 158, 16);
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.f_97735_ + 46 + index * 14;
                int y = this.f_97736_ + 65;
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                int u = index == ((EtchingMenu)this.f_97732_).getLabelIndex() ? 14 : (mouseX >= x && mouseY >= y && mouseX < x + 14 && mouseY < y + 14 ? 28 : 0);
                this.m_93228_(poseStack, x, y, u, 212, 14, 14);
                this.renderLabel(poseStack, x, y, index);
            }
        }
    }

    private void renderLabel(PoseStack poseStack, int x, int y, int index) {
        int primaryLabelColor;
        if (this.labelStack.m_41619_() || this.discStack.m_41619_()) {
            return;
        }
        EtchedMusicDiscItem.LabelPattern pattern = EtchedMusicDiscItem.LabelPattern.values()[index];
        int secondaryLabelColor = primaryLabelColor = 0xFFFFFF;
        if (this.labelStack.m_41720_() instanceof MusicLabelItem) {
            secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(this.labelStack);
        } else if (this.labelStack.m_41720_() instanceof ComplexMusicLabelItem) {
            primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(this.labelStack);
            secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(this.labelStack);
        }
        if (pattern.isColorable()) {
            RenderSystem.m_157429_((float)((float)(primaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        }
        Pair<ResourceLocation, ResourceLocation> textures = pattern.getTextures();
        RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)textures.getLeft()));
        ShapeRenderer.setShader(GameRenderer::m_172814_);
        ShapeRenderer.drawRectWithTexture((PoseStack)poseStack, (float)x, (float)y, (float)1.0f, (float)1.0f, (float)14.0f, (float)14.0f, (float)14.0f, (float)14.0f, (float)16.0f, (float)16.0f);
        if (!pattern.isSimple()) {
            if (pattern.isColorable()) {
                RenderSystem.m_157429_((float)((float)(secondaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)textures.getRight()));
            ShapeRenderer.drawRectWithTexture((PoseStack)poseStack, (float)x, (float)y, (float)1.0f, (float)1.0f, (float)14.0f, (float)14.0f, (float)14.0f, (float)14.0f, (float)16.0f, (float)16.0f);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double mouseX, double mouseY, int i) {
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.f_97735_ + 46 + index * 14;
                int y = this.f_97736_ + 65;
                if (!(mouseX >= (double)x) || !(mouseY >= (double)y) || !(mouseX < (double)(x + 14)) || !(mouseY < (double)(y + 14)) || ((EtchingMenu)this.f_97732_).getLabelIndex() == index) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((EtchingMenu)this.f_97732_).f_38840_, index);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, i);
    }

    public boolean m_7933_(int i, int j, int k) {
        return this.url.m_7933_(i, j, k) || this.url.m_93696_() && this.url.m_94213_() && i != 256 || super.m_7933_(i, j, k);
    }

    public void setReason(String exception) {
        this.invalidReason = exception;
    }
}

