/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.blockentity;

import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.block.RadioBlock;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class RadioBlockEntity
extends BlockEntity
implements Clearable {
    private String url;
    private boolean loaded;

    public RadioBlockEntity(BlockPos pos, BlockState state) {
        super(EtchedBlocks.RADIO_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RadioBlockEntity blockEntity) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        if (!blockEntity.loaded) {
            blockEntity.loaded = true;
            SoundTracker.playRadio(blockEntity.url, state, (ClientLevel)level, pos);
        }
        if (blockEntity.isPlaying()) {
            AABB range = new AABB(pos).m_82400_(3.45);
            List livingEntities = level.m_45976_(LivingEntity.class, range);
            livingEntities.forEach(living -> living.m_6818_(pos, true));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        String string = this.url = nbt.m_128425_("Url", 8) ? nbt.m_128461_("Url") : null;
        if (this.loaded) {
            SoundTracker.playRadio(this.url, this.m_58900_(), (ClientLevel)this.f_58857_, this.m_58899_());
        }
    }

    public void m_183515_(CompoundTag nbt) {
        if (this.url != null) {
            nbt.m_128359_("Url", this.url);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6211_() {
        this.url = null;
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            SoundTracker.playRadio(this.url, this.m_58900_(), (ClientLevel)this.f_58857_, this.m_58899_());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (!Objects.equals(this.url, url)) {
            this.url = url;
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean isPlaying() {
        BlockState state = this.m_58900_();
        return (!state.m_61138_((Property)RadioBlock.POWERED) || (Boolean)state.m_61143_((Property)RadioBlock.POWERED) == false) && !StringUtil.m_14408_((String)this.url);
    }
}

