/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.PlayableRecordItem;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.AlbumCoverMenu;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AlbumCoverItem
extends PlayableRecordItem
implements ContainerItem {
    public static final int MAX_RECORDS = 9;

    public AlbumCoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            if (AlbumCoverItem.dropContents(stack, player)) {
                this.playDropContentsSound((Entity)player);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public AbstractContainerMenu constructMenu(int containerId, Inventory inventory, Player player, int index) {
        return new AlbumCoverMenu(containerId, inventory, index);
    }

    public boolean m_142207_(ItemStack albumCover, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.m_7993_();
        if (clickItem.m_41619_()) {
            AlbumCoverItem.removeOne(albumCover).ifPresent(record -> {
                this.playRemoveOneSound((Entity)player);
                AlbumCoverItem.add(albumCover, slot.m_150659_(record));
            });
        } else if (AlbumCoverItem.canAdd(albumCover, clickItem)) {
            this.playInsertSound((Entity)player);
            AlbumCoverItem.add(albumCover, slot.m_150647_(clickItem.m_41613_(), 1, player));
        }
        return true;
    }

    public boolean m_142305_(ItemStack albumCover, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (clickItem.m_41619_()) {
                AlbumCoverItem.removeOne(albumCover).ifPresent(removedRecord -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(removedRecord);
                });
            } else if (AlbumCoverItem.canAdd(albumCover, clickItem)) {
                this.playInsertSound((Entity)player);
                AlbumCoverItem.add(albumCover, clickItem);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        for (ItemStack record : AlbumCoverItem.getRecords(stack)) {
            if (!(record.m_41720_() instanceof PlayableRecord)) continue;
            record.m_41720_().m_7373_(record, level, list, tooltipFlag);
        }
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, AlbumCoverItem.getRecords(itemEntity.m_32055_()).stream());
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private static Optional<ItemStack> removeOne(ItemStack albumCover) {
        CompoundTag tag = albumCover.m_41784_();
        if (!tag.m_128425_("Records", 9)) {
            return Optional.empty();
        }
        ListTag recordsNbt = tag.m_128437_("Records", 10);
        if (recordsNbt.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag recordNbt = recordsNbt.m_128728_(recordsNbt.size() - 1);
        ItemStack recordStack = ItemStack.m_41712_((CompoundTag)recordNbt);
        recordsNbt.remove(recordsNbt.size() - 1);
        return Optional.of(recordStack);
    }

    private static boolean dropContents(ItemStack itemStack, Player player) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("Records")) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listTag = tag.m_128437_("Records", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                player.m_150109_().m_150079_(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
            }
        }
        itemStack.m_41749_("Records");
        return true;
    }

    private static void add(ItemStack albumCover, ItemStack record) {
        if (!albumCover.m_150930_(EtchedItems.ALBUM_COVER.get()) || !AlbumCoverMenu.isValid(record)) {
            return;
        }
        CompoundTag tag = albumCover.m_41784_();
        if (!tag.m_128441_("Records")) {
            tag.m_128365_("Records", (Tag)new ListTag());
        }
        ListTag recordsNbt = tag.m_128437_("Records", 10);
        ItemStack singleRecord = record.m_41620_(1);
        CompoundTag recordTag = new CompoundTag();
        singleRecord.m_41739_(recordTag);
        recordsNbt.add((Object)recordTag);
        if (!AlbumCoverItem.getCoverStack(albumCover).isPresent()) {
            AlbumCoverItem.getRecords(albumCover).stream().filter(stack -> !stack.m_41619_()).findFirst().ifPresent(stack -> AlbumCoverItem.setCover(albumCover, stack));
        }
    }

    private static boolean canAdd(ItemStack albumCover, ItemStack record) {
        if (!albumCover.m_150930_(EtchedItems.ALBUM_COVER.get()) || !AlbumCoverMenu.isValid(record)) {
            return false;
        }
        return albumCover.m_41783_() == null || !albumCover.m_41783_().m_128425_("Records", 9) || albumCover.m_41783_().m_128437_("Records", 10).size() < 9;
    }

    @Override
    public Optional<TrackData[]> getMusic(ItemStack stack) {
        List<ItemStack> records = AlbumCoverItem.getRecords(stack);
        return records.isEmpty() ? Optional.empty() : Optional.of((TrackData[])records.stream().filter(record -> record.m_41720_() instanceof PlayableRecord).flatMap(record -> Arrays.stream(((PlayableRecord)record.m_41720_()).getMusic((ItemStack)record).orElseGet(() -> new TrackData[0]))).toArray(TrackData[]::new));
    }

    @Override
    public Optional<TrackData> getAlbum(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(ItemStack stack) {
        return AlbumCoverItem.getRecords(stack).stream().filter(record -> record.m_41720_() instanceof PlayableRecord).mapToInt(record -> ((PlayableRecord)record.m_41720_()).getTrackCount((ItemStack)record)).sum();
    }

    public static Optional<ItemStack> getCoverStack(ItemStack stack) {
        if (stack.m_41720_() != EtchedItems.ALBUM_COVER.get()) {
            return Optional.empty();
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128425_("CoverRecord", 10)) {
            return Optional.empty();
        }
        ItemStack cover = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("CoverRecord"));
        return cover.m_41619_() ? Optional.empty() : Optional.of(cover);
    }

    public static List<ItemStack> getRecords(ItemStack stack) {
        if (stack.m_41720_() != EtchedItems.ALBUM_COVER.get()) {
            return Collections.emptyList();
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128425_("Records", 9)) {
            return Collections.emptyList();
        }
        ListTag recordsNbt = nbt.m_128437_("Records", 10);
        if (recordsNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(recordsNbt.size());
        for (int i = 0; i < Math.min(9, recordsNbt.size()); ++i) {
            ItemStack record = ItemStack.m_41712_((CompoundTag)recordsNbt.m_128728_(i));
            if (record.m_41619_()) continue;
            list.add(record);
        }
        return list;
    }

    public static void setCover(ItemStack stack, ItemStack record) {
        if (stack.m_41720_() != EtchedItems.ALBUM_COVER.get()) {
            return;
        }
        if (record.m_41619_()) {
            stack.m_41749_("CoverRecord");
            return;
        }
        stack.m_41784_().m_128365_("CoverRecord", (Tag)record.m_41739_(new CompoundTag()));
    }

    public static void setRecords(ItemStack stack, Collection<ItemStack> records) {
        if (stack.m_41720_() != EtchedItems.ALBUM_COVER.get() || records.isEmpty()) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        ListTag recordsNbt = new ListTag();
        int i = 0;
        for (ItemStack record : records) {
            if (record.m_41619_()) continue;
            if (i >= 9) break;
            recordsNbt.add((Object)record.m_41739_(new CompoundTag()));
            ++i;
        }
        nbt.m_128365_("Records", (Tag)recordsNbt);
    }
}

