/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.BoomboxMenu;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends Item
implements ContainerItem {
    private static final Map<Integer, ItemStack> PLAYING_RECORDS = new Int2ObjectArrayMap();
    private static final Component PAUSE = new TranslatableComponent("item.etched.boombox.pause", new Object[]{new KeybindComponent("key.sneak"), new KeybindComponent("key.use")}).m_130940_(ChatFormatting.GRAY);
    private static final Component RECORDS = new TranslatableComponent("item.etched.boombox.records");
    public static final Component PAUSED = new TranslatableComponent("item.etched.boombox.paused").m_130940_(ChatFormatting.YELLOW);

    public BoomboxItem(Item.Properties properties) {
        super(properties);
    }

    private static void updatePlaying(Entity entity, ItemStack record) {
        if (!ItemStack.m_41728_((ItemStack)PLAYING_RECORDS.getOrDefault(entity.m_142049_(), ItemStack.f_41583_), (ItemStack)record)) {
            SoundTracker.playBoombox(entity.m_142049_(), record);
            if (record.m_41619_()) {
                PLAYING_RECORDS.remove(entity.m_142049_());
            } else {
                PLAYING_RECORDS.put(entity.m_142049_(), record);
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.f_19853_.m_5776_()) {
            return false;
        }
        BoomboxItem.updatePlaying((Entity)entity, BoomboxItem.hasRecord(stack) && !BoomboxItem.isPaused(stack) ? BoomboxItem.getRecord(stack) : ItemStack.f_41583_);
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            BoomboxItem.setPaused(stack, !BoomboxItem.isPaused(stack));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (!((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public AbstractContainerMenu constructMenu(int containerId, Inventory inventory, Player player, int index) {
        return new BoomboxMenu(containerId, inventory, index);
    }

    public boolean m_142207_(ItemStack boombox, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.m_7993_();
        if (clickItem.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            BoomboxItem.removeOne(boombox).ifPresent(key -> BoomboxItem.setRecord(boombox, slot.m_150659_(key)));
        } else if (BoomboxItem.canAdd(boombox, clickItem)) {
            this.playInsertSound((Entity)player);
            BoomboxItem.setRecord(boombox, slot.m_150647_(clickItem.m_41613_(), 1, player).m_41620_(1));
        }
        return true;
    }

    public boolean m_142305_(ItemStack boombox, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (clickItem.m_41619_()) {
                BoomboxItem.removeOne(boombox).ifPresent(removedKey -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(removedKey);
                });
            } else if (BoomboxItem.canAdd(boombox, clickItem)) {
                this.playInsertSound((Entity)player);
                BoomboxItem.setRecord(boombox, clickItem.m_41620_(1));
            }
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add(PAUSE);
        if (BoomboxItem.hasRecord(stack)) {
            ItemStack record = BoomboxItem.getRecord(stack);
            LinkedList records = new LinkedList();
            record.m_41720_().m_7373_(record, level, records, isAdvanced);
            if (!records.isEmpty()) {
                tooltipComponents.add(TextComponent.f_131282_);
                tooltipComponents.add(RECORDS);
                tooltipComponents.addAll(records);
            }
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    @Nullable
    public static InteractionHand getPlayingHand(LivingEntity entity) {
        if (!PLAYING_RECORDS.containsKey(entity.m_142049_())) {
            return null;
        }
        ItemStack stack = entity.m_21205_();
        if (stack.m_41720_() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return InteractionHand.MAIN_HAND;
        }
        stack = entity.m_21206_();
        if (stack.m_41720_() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static boolean isPaused(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BoomboxItem)) {
            return false;
        }
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128471_("Paused");
    }

    public static boolean hasRecord(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BoomboxItem)) {
            return false;
        }
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128425_("Record", 10);
    }

    public static ItemStack getRecord(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BoomboxItem)) {
            return ItemStack.f_41583_;
        }
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128425_("Record", 10) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Record")) : ItemStack.f_41583_;
    }

    public static void setRecord(ItemStack stack, ItemStack record) {
        if (!(stack.m_41720_() instanceof BoomboxItem)) {
            return;
        }
        if (record.m_41619_()) {
            stack.m_41749_("Record");
        } else {
            stack.m_41784_().m_128365_("Record", (Tag)record.m_41739_(new CompoundTag()));
        }
    }

    public static void setPaused(ItemStack stack, boolean paused) {
        if (!(stack.m_41720_() instanceof BoomboxItem)) {
            return;
        }
        if (!paused) {
            stack.m_41749_("Paused");
        } else {
            stack.m_41784_().m_128379_("Paused", true);
        }
    }

    private static Optional<ItemStack> removeOne(ItemStack boombox) {
        if (!BoomboxItem.hasRecord(boombox)) {
            return Optional.empty();
        }
        ItemStack record = BoomboxItem.getRecord(boombox);
        if (record.m_41619_()) {
            return Optional.empty();
        }
        BoomboxItem.setRecord(boombox, ItemStack.f_41583_);
        return Optional.of(record);
    }

    private static boolean canAdd(ItemStack boombox, ItemStack record) {
        if (!boombox.m_150930_(EtchedItems.BOOMBOX.get()) || !(record.m_41720_() instanceof PlayableRecord)) {
            return false;
        }
        return BoomboxItem.getRecord(boombox).m_41619_();
    }

    static {
        TickEvents.LIVING_PRE.register(entity -> {
            if (!entity.f_19853_.m_5776_()) {
                return true;
            }
            ItemStack newPlayingRecord = ItemStack.f_41583_;
            ItemStack mainStack = entity.m_21205_();
            ItemStack offStack = entity.m_21206_();
            if (mainStack.m_41720_() instanceof BoomboxItem && BoomboxItem.hasRecord(mainStack) && !BoomboxItem.isPaused(mainStack)) {
                newPlayingRecord = BoomboxItem.getRecord(mainStack);
            } else if (offStack.m_41720_() instanceof BoomboxItem && BoomboxItem.hasRecord(offStack) && !BoomboxItem.isPaused(offStack)) {
                newPlayingRecord = BoomboxItem.getRecord(offStack);
            }
            if (entity instanceof Player && newPlayingRecord.m_41619_() && Minecraft.m_91087_().f_91075_ == entity) {
                Inventory inventory = ((Player)entity).m_150109_();
                for (ItemStack stack : inventory.f_35974_) {
                    if (!(stack.m_41720_() instanceof BoomboxItem) || !BoomboxItem.hasRecord(stack) || BoomboxItem.isPaused(stack)) continue;
                    newPlayingRecord = BoomboxItem.getRecord(stack);
                }
            }
            BoomboxItem.updatePlaying((Entity)entity, newPlayingRecord);
            return true;
        });
    }
}

