/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import gg.moonflower.etched.common.menu.AlbumCoverContainer;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.pollen.api.util.QuickMoveHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AlbumCoverMenu
extends AbstractContainerMenu {
    private static final QuickMoveHelper MOVE_HELPER = new QuickMoveHelper().add(0, 9, 9, 36, true).add(9, 36, 0, 9, false);
    private final Inventory inventory;
    private final Container albumCoverInventory;
    private final int albumCoverIndex;

    public AlbumCoverMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, -1);
    }

    public AlbumCoverMenu(int containerId, Inventory inventory, int albumCoverIndex) {
        super(EtchedMenus.ALBUM_COVER_MENU.get(), containerId);
        this.albumCoverInventory = albumCoverIndex == -1 ? new SimpleContainer(9) : new AlbumCoverContainer(inventory, albumCoverIndex);
        this.albumCoverIndex = albumCoverIndex;
        this.inventory = inventory;
        for (int n = 0; n < 3; ++n) {
            for (int m = 0; m < 3; ++m) {
                this.m_38897_(new Slot(this.albumCoverInventory, m + n * 3, 62 + m * 18, 17 + n * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return AlbumCoverMenu.isValid(stack);
                    }
                });
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, y * 18 + 84){

                    public boolean m_8010_(Player player) {
                        return this.m_7993_().m_41720_() != EtchedItems.ALBUM_COVER.get();
                    }
                });
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142){

                public boolean m_8010_(Player player) {
                    return this.m_7993_().m_41720_() != EtchedItems.ALBUM_COVER.get();
                }
            });
        }
    }

    public boolean m_6875_(Player player) {
        return this.albumCoverInventory.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.albumCoverIndex == -1) {
            return;
        }
        ItemStack cover = this.inventory.m_8020_(this.albumCoverIndex);
        if (!AlbumCoverItem.getCoverStack(cover).isPresent()) {
            for (int i = 0; i < this.albumCoverInventory.m_6643_(); ++i) {
                ItemStack stack = this.albumCoverInventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                AlbumCoverItem.setCover(cover, stack);
                break;
            }
        }
    }

    public ItemStack m_7648_(Player player, int slot) {
        return MOVE_HELPER.quickMoveStack((AbstractContainerMenu)this, player, slot);
    }

    public static boolean isValid(ItemStack stack) {
        return PlayableRecord.isPlayableRecord(stack) && !stack.m_150930_(EtchedItems.ALBUM_COVER.get());
    }
}

