/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play;

import gg.moonflower.etched.common.network.play.handler.EtchedClientPlayPacketHandler;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundPlayEntityMusicPacket
implements PollinatedPacket<EtchedClientPlayPacketHandler> {
    private final Action action;
    private final ItemStack record;
    private final int entityId;

    public ClientboundPlayEntityMusicPacket(ItemStack record, Entity entity, boolean restart) {
        this.action = restart ? Action.RESTART : Action.START;
        this.record = record;
        this.entityId = entity.m_142049_();
    }

    public ClientboundPlayEntityMusicPacket(Entity entity) {
        this.action = Action.STOP;
        this.record = ItemStack.f_41583_;
        this.entityId = entity.m_142049_();
    }

    public ClientboundPlayEntityMusicPacket(FriendlyByteBuf buf) {
        this.action = (Action)buf.m_130066_(Action.class);
        this.record = this.action == Action.STOP ? ItemStack.f_41583_ : buf.m_130267_();
        this.entityId = buf.m_130242_();
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
        if (this.action != Action.STOP) {
            buf.m_130055_(this.record);
        }
        buf.m_130130_(this.entityId);
    }

    public void processPacket(EtchedClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handlePlayEntityMusicPacket(this, ctx);
    }

    public Action getAction() {
        return this.action;
    }

    public ItemStack getRecord() {
        return this.record;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static enum Action {
        START,
        STOP,
        RESTART;

    }
}

