/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core;

import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.client.render.entity.JukeboxMinecartRenderer;
import gg.moonflower.etched.client.render.item.AlbumCoverItemRenderer;
import gg.moonflower.etched.client.render.model.EtchedModelLayers;
import gg.moonflower.etched.client.screen.AlbumCoverScreen;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.BoomboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.BoomboxItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.sound.download.BandcampSource;
import gg.moonflower.etched.common.sound.download.SoundCloudSource;
import gg.moonflower.etched.core.EtchedConfig;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedEntities;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedRecipes;
import gg.moonflower.etched.core.registry.EtchedSounds;
import gg.moonflower.etched.core.registry.EtchedVillagers;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.event.events.entity.ModifyTradesEvents;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.client.ColorRegistry;
import gg.moonflower.pollen.api.registry.client.EntityRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ItemPredicateRegistry;
import gg.moonflower.pollen.api.registry.client.ItemRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ModelRegistry;
import gg.moonflower.pollen.api.registry.client.RenderTypeRegistry;
import gg.moonflower.pollen.api.registry.client.ScreenRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Etched {
    public static final String MOD_ID = "etched";
    public static final EtchedConfig.Client CLIENT_CONFIG = (EtchedConfig.Client)ConfigManager.register((String)"etched", (PollinatedConfigType)PollinatedConfigType.CLIENT, EtchedConfig.Client::new);
    public static final EtchedConfig.Server SERVER_CONFIG = (EtchedConfig.Server)ConfigManager.register((String)"etched", (PollinatedConfigType)PollinatedConfigType.SERVER, EtchedConfig.Server::new);
    public static final Platform PLATFORM = Platform.builder((String)"etched").commonInit(Etched::commonInit).commonPostInit(Etched::commonPostInit).clientInit(Etched::clientInit).clientPostInit(Etched::clientPostInit).build();

    public static void commonInit() {
        EtchedBlocks.BLOCKS.register(PLATFORM);
        EtchedBlocks.BLOCK_ENTITIES.register(PLATFORM);
        EtchedItems.ITEMS.register(PLATFORM);
        EtchedEntities.ENTITIES.register(PLATFORM);
        EtchedMenus.MENUS.register(PLATFORM);
        EtchedSounds.SOUNDS.register(PLATFORM);
        EtchedVillagers.POI_TYPES.register(PLATFORM);
        EtchedVillagers.PROFESSIONS.register(PLATFORM);
        EtchedRecipes.RECIPES.register(PLATFORM);
        EtchedMessages.init();
        ModifyTradesEvents.VILLAGER.register(context -> {
            if (context.getProfession() != EtchedVillagers.BARD.get()) {
                return;
            }
            ModifyTradesEvents.TradeRegistry tier1 = context.getTrades(1);
            tier1.add((ItemLike)Items.f_42752_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_42710_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_42701_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_186363_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_41859_, 1, 2, 16, 2, true);
            tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
            ModifyTradesEvents.TradeRegistry tier2 = context.getTrades(2);
            tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
            tier2.add(EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
            ModifyTradesEvents.TradeRegistry tier3 = context.getTrades(3);
            tier3.add((ItemLike)Blocks.f_50129_, 6, 1, 16, 2, false);
            tier3.add((ItemLike)Blocks.f_50335_, 12, 1, 8, 2, false);
            tier3.add((ItemLike)Blocks.f_50041_, 8, 1, 32, 4, false);
            tier3.add((ItemLike)Blocks.f_50453_, 24, 1, 8, 4, false);
            tier3.add((ItemLike)Blocks.f_50354_, 36, 1, 4, 8, false);
            tier3.add((ItemLike)Blocks.f_50074_, 48, 1, 2, 10, false);
            ModifyTradesEvents.TradeRegistry tier4 = context.getTrades(4);
            tier3.add((ItemLike)Items.f_41984_, 26, 1, 4, 30, false);
            tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
            tier4.add(EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
            ModifyTradesEvents.TradeRegistry tier5 = context.getTrades(5);
            tier5.add((ItemLike)Items.f_42415_, 8, 1, 8, 40, true);
            tier5.add((ItemLike)Items.f_151049_, 1, 8, 10, 40, true);
            Registry.f_122827_.m_203431_(ItemTags.f_13158_).ifPresent(tag -> tag.m_203614_().forEach(item -> tier5.add((ItemLike)item.m_203334_(), 10, 1, 4, 40, true)));
        });
    }

    public static void clientInit() {
        RegisterAtlasSpriteEvent.event((ResourceLocation)InventoryMenu.f_39692_).register((atlas, registry) -> {
            registry.accept(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_disc"));
            registry.accept(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_label"));
        });
        ClientLoading.load();
        ModelRegistry.registerFactory((resourceManager, out) -> {
            String folder = "models/item/etched_album_cover/";
            for (ResourceLocation animationLocation : resourceManager.m_6540_(folder, name -> name.endsWith(".json"))) {
                out.accept(new ModelResourceLocation(new ResourceLocation(animationLocation.m_135827_(), animationLocation.m_135815_().substring(12, animationLocation.m_135815_().length() - 5)), "inventory"));
            }
        });
        ColorRegistry.register((stack, index) -> index == 0 || index == 1 ? MusicLabelItem.getLabelColor(stack) : -1, (Supplier[])new Supplier[]{EtchedItems.MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index == 0 ? ComplexMusicLabelItem.getPrimaryColor(stack) : (index == 1 ? ComplexMusicLabelItem.getSecondaryColor(stack) : -1), (Supplier[])new Supplier[]{EtchedItems.COMPLEX_MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index > 0 ? -1 : ((BlankMusicDiscItem)stack.m_41720_()).m_41121_(stack), (Supplier[])new Supplier[]{EtchedItems.BLANK_MUSIC_DISC});
        ColorRegistry.register((stack, index) -> index == 0 ? EtchedMusicDiscItem.getDiscColor(stack) : (EtchedMusicDiscItem.getPattern(stack).isColorable() ? (index == 1 ? EtchedMusicDiscItem.getLabelPrimaryColor(stack) : (index == 2 ? EtchedMusicDiscItem.getLabelSecondaryColor(stack) : -1)) : -1), (Supplier[])new Supplier[]{EtchedItems.ETCHED_MUSIC_DISC});
        EntityRendererRegistry.registerLayerDefinition((ModelLayerLocation)EtchedModelLayers.JUKEBOX_MINECART, MinecartModel::m_170738_);
        EntityRendererRegistry.register(EtchedEntities.JUKEBOX_MINECART, JukeboxMinecartRenderer::new);
        AlbumCoverItemRenderer.init();
    }

    public static void commonPostInit(Platform.ModSetupContext ctx) {
        SoundSourceManager.registerSource(new SoundCloudSource());
        SoundSourceManager.registerSource(new BandcampSource());
        ctx.enqueueWork(EtchedVillagers::registerVillages);
    }

    public static void clientPostInit(Platform.ModSetupContext ctx) {
        ctx.enqueueWork(() -> {
            ScreenRegistry.register(EtchedMenus.ETCHING_MENU.get(), EtchingScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_JUKEBOX_MENU.get(), AlbumJukeboxScreen::new);
            ScreenRegistry.register(EtchedMenus.BOOMBOX_MENU.get(), BoomboxScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_COVER_MENU.get(), AlbumCoverScreen::new);
            ScreenRegistry.register(EtchedMenus.RADIO_MENU.get(), RadioScreen::new);
            ItemPredicateRegistry.register((Item)EtchedItems.BOOMBOX.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "playing"), (stack, level, entity, i) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                InteractionHand hand = BoomboxItem.getPlayingHand(entity);
                return hand != null && stack == entity.m_21120_(hand) ? 1.0f : 0.0f;
            });
            ItemPredicateRegistry.register((Item)EtchedItems.ETCHED_MUSIC_DISC.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "pattern"), (stack, level, entity, i) -> (float)EtchedMusicDiscItem.getPattern(stack).ordinal() / 10.0f);
        });
        RenderTypeRegistry.register((Block)EtchedBlocks.ETCHING_TABLE.get(), (RenderType)RenderType.m_110463_());
        RenderTypeRegistry.register((Block)EtchedBlocks.RADIO.get(), (RenderType)RenderType.m_110463_());
        ItemRendererRegistry.registerHandModel((ItemLike)((ItemLike)EtchedItems.BOOMBOX.get()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(MOD_ID, "boombox_in_hand"), "inventory"));
        ItemRendererRegistry.registerRenderer((ItemLike)((ItemLike)EtchedItems.ALBUM_COVER.get()), (DynamicItemRenderer)AlbumCoverItemRenderer.INSTANCE);
    }

    private static class ClientLoading {
        private ClientLoading() {
        }

        private static void load() {
            ModelRegistry.registerSpecial((ResourceLocation)new ModelResourceLocation(new ResourceLocation(Etched.MOD_ID, "boombox_in_hand"), "inventory"));
        }
    }
}

