/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.forge.datagen;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.etched.core.registry.EtchedItems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemModelGen
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer;

    public ItemModelGen(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    private static Path createModelPath(Path dataFolder, ResourceLocation name) {
        return dataFolder.resolve("assets/" + name.m_135827_() + "/models/" + name.m_135815_() + ".json");
    }

    public void m_6865_(HashCache cache) {
        Path path = this.dataGenerator.m_123916_();
        HashMap map1 = Maps.newHashMap();
        this.consumer = (location, json) -> {
            Supplier supplier = map1.put(location, json);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + location);
            }
        };
        this.register();
        this.saveCollection(cache, path, map1, ItemModelGen::createModelPath);
    }

    private void register() {
        this.generateFlatItem(EtchedItems.BLANK_MUSIC_DISC.get(), ModelTemplates.f_125658_);
        this.generateFlatItem(EtchedItems.JUKEBOX_MINECART.get(), ModelTemplates.f_125658_);
    }

    private void generateFlatItem(Item item, ModelTemplate p_240076_2_) {
        p_240076_2_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), this.consumer);
    }

    private void generateFlatItem(Item item, String p_240077_2_, ModelTemplate p_240077_3_) {
        p_240077_3_.m_125612_(ModelLocationUtils.m_125573_((Item)item, (String)p_240077_2_), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125745_((Item)item, (String)p_240077_2_)), this.consumer);
    }

    private void generateFlatItem(Item item, Item p_240075_2_, ModelTemplate p_240075_3_) {
        p_240075_3_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)p_240075_2_), this.consumer);
    }

    private <T> void saveCollection(HashCache cache, Path dataFolder, Map<T, ? extends Supplier<JsonElement>> models, BiFunction<Path, T, Path> resolver) {
        models.forEach((p_240088_3_, p_240088_4_) -> {
            Path path = (Path)resolver.apply(dataFolder, p_240088_3_);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)p_240088_4_.get()), (Path)path);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        });
    }

    public String m_6055_() {
        return "etched Block State Definitions";
    }
}

