/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.forge.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.FishingLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableGen
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(FishingProvider::new, (Object)LootContextParamSets.f_81414_), (Object)Pair.of(ChestProvider::new, (Object)LootContextParamSets.f_81411_), (Object)Pair.of(EntityProvider::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(BlockProvider::new, (Object)LootContextParamSets.f_81421_));

    public LootTableGen(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    private static class BlockProvider
    extends BlockLoot {
        private BlockProvider() {
        }

        protected void addTables() {
            this.m_124288_(EtchedBlocks.ETCHING_TABLE.get());
            this.m_124288_(EtchedBlocks.ALBUM_JUKEBOX.get());
            this.m_124288_(EtchedBlocks.RADIO.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "etched".equals(entityType.getRegistryName().m_135827_())).collect(Collectors.toSet());
        }
    }

    private static class EntityProvider
    extends EntityLoot {
        private EntityProvider() {
        }

        protected void addTables() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "etched".equals(entityType.getRegistryName().m_135827_())).collect(Collectors.toSet());
        }
    }

    private static class ChestProvider
    extends ChestLoot {
        private ChestProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }

    private static class FishingProvider
    extends FishingLoot {
        private FishingProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }
}

