/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin;

import com.google.common.base.Suppliers;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.client.sound.EntityRecordSoundInstance;
import gg.moonflower.etched.core.hook.RecordItemHook;
import gg.moonflower.etched.core.mixin.SoundEventAccessor;
import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RecordItem.class})
public abstract class RecordItemMixin
extends Item
implements PlayableRecord {
    @Unique
    private final Supplier<TrackData[]> track = Suppliers.memoize(() -> {
        TranslatableComponent desc = new TranslatableComponent(this.m_5524_() + ".desc");
        String[] parts = desc.getString().split("-", 2);
        if (parts.length < 2) {
            return new TrackData[]{new TrackData(((SoundEventAccessor)RecordItemHook.getSound((RecordItem)this)).getLocation().toString(), "Minecraft", (Component)desc)};
        }
        return new TrackData[]{new TrackData(((SoundEventAccessor)RecordItemHook.getSound((RecordItem)this)).getLocation().toString(), parts[0].trim(), (Component)new TextComponent(parts[1].trim()).m_130948_(desc.m_7383_()))};
    });

    private RecordItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canPlay(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<? extends SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track) {
        if (track != 0 || !(stack.m_41720_() instanceof RecordItem)) {
            return Optional.empty();
        }
        if (PlayableRecord.canShowMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) {
            PlayableRecord.showMessage((Component)((RecordItem)stack.m_41720_()).m_43050_());
        }
        return Optional.of(new EntityRecordSoundInstance(((RecordItem)stack.m_41720_()).m_43051_(), entity));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack stack, Proxy proxy, ResourceManager resourceManager) {
        ResourceLocation key = Registry.f_122827_.m_7981_((Object)this);
        return resourceManager.m_7165_(new ResourceLocation(key.m_135827_(), "models/item/etched_album_cover/" + key.m_135815_() + ".json")) ? CompletableFuture.completedFuture(AlbumCover.of(new ResourceLocation(key.m_135827_(), "etched_album_cover/" + key.m_135815_()))) : CompletableFuture.completedFuture(AlbumCover.EMPTY);
    }

    @Override
    public Optional<TrackData[]> getMusic(ItemStack stack) {
        return Optional.of(this.track.get());
    }

    @Override
    public Optional<TrackData> getAlbum(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(ItemStack stack) {
        return 1;
    }
}

