/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.item.BoomboxItem;
import gg.moonflower.etched.core.hook.extension.VillagerExtension;
import gg.moonflower.etched.core.registry.EtchedTags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements VillagerExtension {
    @Unique
    private boolean dancing;
    @Unique
    private BlockPos musicPos;

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8107_() {
        if (this.f_19853_.m_5776_()) {
            if (this.m_20089_() != Pose.STANDING) {
                this.dancing = false;
                return;
            }
            List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(3.45), entity -> {
                if (!entity.m_6084_() || entity.m_5833_()) {
                    return false;
                }
                if (entity == Minecraft.m_91087_().f_91074_ && BoomboxItem.getPlayingHand((LivingEntity)entity) == null) {
                    return false;
                }
                return SoundTracker.getEntitySound(entity.m_142049_()) != null;
            });
            if (!entities.isEmpty()) {
                this.dancing = true;
            } else if (this.musicPos == null || !this.musicPos.m_203195_((Position)this.m_20182_(), 3.46) || !this.f_19853_.m_8055_(this.musicPos).m_60713_(Blocks.f_50131_) && !this.f_19853_.m_8055_(this.musicPos).m_204336_(EtchedTags.AUDIO_PROVIDER)) {
                this.dancing = false;
                this.musicPos = null;
            }
            if (this.dancing && this.f_21363_ > -this.m_8100_() + 20) {
                this.f_21363_ = -this.m_8100_();
                if (this.f_19796_.nextBoolean()) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20208_(1.0), this.m_20227_(1.0) + this.f_19796_.nextDouble() / 2.0, this.m_20262_(1.0), (double)((float)this.f_19796_.nextInt(25) / 24.0f), 0.0, 0.0);
                    if (this.f_19796_.nextDouble() > 0.75) {
                        this.f_19853_.m_5594_((Player)Minecraft.m_91087_().f_91074_, this.m_142538_(), SoundEvents.f_12509_, this.m_5720_(), this.m_6121_(), this.m_6100_());
                    }
                }
            }
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.musicPos = pos;
        this.dancing = isPartying;
    }

    @Override
    public boolean isDancing() {
        return this.dancing;
    }
}

