/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.core.hook.extension.VillagerExtension;
import gg.moonflower.etched.core.util.AnimationUtil;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedGeometryEntityModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerModel.class})
public abstract class VillagerModelMixin<T extends Entity> {
    private static final AnimatedGeometryEntityModel<Entity> RIG = new AnimatedGeometryEntityModel(new ResourceLocation("etched", "villager"));
    private static final Set<String> USED_BONES = new HashSet<String>();
    private static final Map<String, PartPose> ORIGINS = new HashMap<String, PartPose>();
    @Shadow
    @Final
    private ModelPart f_171047_;

    @Shadow
    public abstract ModelPart m_142109_();

    private PartPose getOrigin(String name) {
        return ORIGINS.computeIfAbsent(name, s -> this.m_142109_().m_171324_(name).m_171308_());
    }

    private void reset(ModelPart part, String name) {
        part.m_171322_(this.getOrigin(name));
    }

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void reset(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension)) {
            return;
        }
        this.reset(this.f_171047_.m_171324_("head"), "head");
        this.reset(this.f_171047_.m_171324_("body"), "body");
        this.reset(this.f_171047_.m_171324_("arms"), "arms");
        this.reset(this.f_171047_.m_171324_("left_leg"), "left_leg");
        this.reset(this.f_171047_.m_171324_("right_leg"), "right_leg");
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void animate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension) || !((VillagerExtension)entity).isDancing()) {
            return;
        }
        USED_BONES.clear();
        RIG.setAnimations(new ResourceLocation[]{new ResourceLocation("etched", "dance")});
        for (AnimationData animation : RIG.getAnimations()) {
            for (AnimationData.BoneAnimation boneAnimation : animation.getBoneAnimations()) {
                USED_BONES.add(boneAnimation.getName());
            }
        }
        RIG.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        GeometryModel model = RIG.getModel();
        USED_BONES.forEach(s -> AnimationUtil.copyAngles(s, model, this.m_142109_().m_171324_(s)));
    }
}

