/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class EtchedVillagers {
    public static final PollinatedRegistry<VillagerProfession> PROFESSIONS = PollinatedRegistry.create((Registry)Registry.f_122869_, (String)"etched");
    public static final PollinatedRegistry<PoiType> POI_TYPES = PollinatedRegistry.create((Registry)Registry.f_122870_, (String)"etched");
    public static final Supplier<PoiType> BARD_POI = POI_TYPES.register("bard", () -> PoiType.m_27367_((PoiType)new PoiType("etched:bard", (Set)ImmutableSet.builder().addAll((Iterable)Blocks.f_50065_.m_49965_().m_61056_()).build(), 1, 1)));
    public static final Supplier<VillagerProfession> BARD = PROFESSIONS.register("bard", () -> new VillagerProfession("etched:bard", BARD_POI.get(), ImmutableSet.of(), ImmutableSet.of(), null));

    public static void registerVillages() {
        PlainVillagePools.m_127185_();
        DesertVillagePools.m_126860_();
        SavannaVillagePools.m_127230_();
        SnowyVillagePools.m_127233_();
        TaigaVillagePools.m_127305_();
        EtchedVillagers.createVillagePiece("plains", "bard_house", 1, 2, (Holder<StructureProcessorList>)ProcessorLists.f_127204_, (Holder<StructureProcessorList>)ProcessorLists.f_127199_);
        EtchedVillagers.createVillagePiece("desert", "bard_house", 1, 2, (Holder<StructureProcessorList>)ProcessorLists.f_127203_);
        EtchedVillagers.createVillagePiece("savanna", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127200_);
        EtchedVillagers.createVillagePiece("snowy", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127201_);
        EtchedVillagers.createVillagePiece("taiga", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127204_, (Holder<StructureProcessorList>)ProcessorLists.f_127202_);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, Holder<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.createVillagePiece(village, name, houseId, weight, (Holder<StructureProcessorList>)ProcessorLists.f_127198_, zombieProcessor);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, Holder<StructureProcessorList> normalProcessor, Holder<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), normalProcessor, weight);
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/zombie/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), zombieProcessor, weight);
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation pieceId, Holder<StructureProcessorList> processorList, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(poolId);
        if (pool == null) {
            return;
        }
        StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.m_210512_((String)pieceId.toString(), processorList).apply(StructureTemplatePool.Projection.RIGID);
        List<StructurePoolElement> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        List<Pair<StructurePoolElement, Integer>> rawTemplates = ((StructureTemplatePoolAccessor)pool).getRawTemplates();
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
        rawTemplates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)piece, (Object)weight));
    }
}

