/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TrackData {
    public static final TrackData EMPTY = new TrackData(null, "Unknown", (Component)Component.m_237113_((String)"Custom Music"));
    public static final Codec<TrackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Url").forGetter(TrackData::getUrl), (App)Codec.STRING.optionalFieldOf("Author", (Object)EMPTY.getArtist()).forGetter(TrackData::getArtist), (App)Codec.STRING.optionalFieldOf("Title", (Object)Component.Serializer.m_130703_((Component)EMPTY.getTitle())).xmap(json -> {
        if (!json.startsWith("{")) {
            return Component.m_237113_((String)json);
        }
        try {
            return Component.Serializer.m_130701_((String)json);
        }
        catch (JsonParseException e) {
            return Component.m_237113_((String)json);
        }
    }, Component.Serializer::m_130703_).forGetter(TrackData::getTitle)).apply((Applicative)instance, TrackData::new));
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");
    private final String url;
    private final String artist;
    private final Component title;

    public TrackData(String url, String artist, Component title) {
        this.url = url;
        this.artist = artist;
        this.title = title;
    }

    public static boolean isValid(CompoundTag nbt) {
        return nbt.m_128425_("Url", 8) && TrackData.isValidURL(nbt.m_128461_("Url"));
    }

    public static boolean isValidURL(@Nullable String url) {
        if (url == null) {
            return false;
        }
        if (TrackData.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(@Nullable String url) {
        if (url == null) {
            return false;
        }
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag save(CompoundTag nbt) {
        if (this.url != null) {
            nbt.m_128359_("Url", this.url);
        }
        if (this.title != null) {
            nbt.m_128359_("Title", Component.Serializer.m_130703_((Component)this.title));
        }
        if (this.artist != null) {
            nbt.m_128359_("Author", this.artist);
        }
        return nbt;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArtist() {
        return this.artist;
    }

    public Component getTitle() {
        return this.title;
    }

    public TrackData withUrl(String url) {
        return new TrackData(url, this.artist, this.title);
    }

    public TrackData withArtist(String artist) {
        return new TrackData(this.url, artist, this.title);
    }

    public TrackData withTitle(String title) {
        return new TrackData(this.url, this.artist, (Component)Component.m_237113_((String)title));
    }

    public TrackData withTitle(Component title) {
        return new TrackData(this.url, this.artist, title);
    }

    public Component getDisplayName() {
        return Component.m_237110_((String)"sound_source.etched.info", (Object[])new Object[]{this.artist, this.title});
    }
}

