/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.source;

import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.client.sound.SoundCache;
import gg.moonflower.etched.core.util.AsyncInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.util.HttpUtil;
import org.jetbrains.annotations.Nullable;

public class RawAudioSource
implements AudioSource {
    private final CompletableFuture<AsyncInputStream.InputStreamSupplier> locationFuture;
    private CompletableFuture<InputStream> stream;

    public RawAudioSource(String hash, URL url, @Nullable DownloadProgressListener listener, boolean temporary, AudioSource.AudioFileType type) throws IOException {
        Path location = SoundCache.resolveFilePath(hash, temporary);
        this.locationFuture = CompletableFuture.supplyAsync(() -> AudioSource.downloadTo(location, url, listener, type), (Executor)HttpUtil.f_13936_);
    }

    @Override
    public CompletableFuture<InputStream> openStream() {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = this.locationFuture.thenApplyAsync(stream -> {
            try {
                return stream.get();
            }
            catch (Exception e) {
                throw new CompletionException("Failed to open stream", e);
            }
        }, (Executor)Util.m_183992_());
        return this.stream;
    }
}

