/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.client.render.entity.VillagerAnimation;
import gg.moonflower.etched.core.hook.VillagerExtension;
import gg.moonflower.etched.core.util.AnimationUtil;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.pinwheel.api.animation.AnimationData;
import gg.moonflower.pinwheel.api.animation.PlayingAnimation;
import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryModelManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerModel.class})
public abstract class VillagerModelMixin<T extends Entity> {
    @Unique
    private static final ResourceLocation MODEL_LOCATION = new ResourceLocation("etched", "villager");
    @Unique
    private static final MolangEnvironment ENVIRONMENT = MolangRuntime.runtime().create();
    @Unique
    private static final PlayingAnimation ANIMATION = new VillagerAnimation();
    @Unique
    private static final Set<String> USED_BONES = new HashSet<String>();
    @Unique
    private static final Map<String, PartPose> ORIGINS = new HashMap<String, PartPose>();
    @Shadow
    @Final
    private ModelPart f_171047_;

    @Shadow
    public abstract ModelPart m_142109_();

    @Unique
    private PartPose getOrigin(String name) {
        return ORIGINS.computeIfAbsent(name, s -> this.m_142109_().m_171324_(name).m_171308_());
    }

    @Unique
    private void reset(ModelPart part, String name) {
        part.m_171322_(this.getOrigin(name));
    }

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void reset(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension)) {
            return;
        }
        this.reset(this.f_171047_.m_171324_("head"), "head");
        this.reset(this.f_171047_.m_171324_("body"), "body");
        this.reset(this.f_171047_.m_171324_("arms"), "arms");
        this.reset(this.f_171047_.m_171324_("left_leg"), "left_leg");
        this.reset(this.f_171047_.m_171324_("right_leg"), "right_leg");
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void animate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        VillagerExtension ext;
        if (!(entity instanceof VillagerExtension) || !(ext = (VillagerExtension)entity).isDancing()) {
            return;
        }
        GeometryModel model = GeometryModelManager.getModel((ResourceLocation)MODEL_LOCATION);
        if (model == GeometryModel.EMPTY) {
            return;
        }
        ANIMATION.setAnimationTime(ageInTicks / 20.0f);
        model.applyAnimations(ENVIRONMENT, List.of(ANIMATION));
        USED_BONES.clear();
        for (AnimationData.BoneAnimation boneAnimation : ANIMATION.getAnimation().boneAnimations()) {
            USED_BONES.add(boneAnimation.name());
        }
        USED_BONES.forEach(s -> AnimationUtil.copyAngles(s, model, this.m_142109_().m_171324_(s)));
        USED_BONES.clear();
    }
}

