/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncInputStream
extends InputStream {
    private static final int MAX_DATA = 32768;
    private final List<byte[]> readBytes = new LinkedList<byte[]>();
    private final CompletableFuture<?> readFuture;
    private final Lock lock = new ReentrantLock();
    private final int maxBuffers;
    private int pointer;
    private byte[] currentData;
    private volatile boolean closed;
    private CompletableFuture<?> waitFuture;

    public AsyncInputStream(InputStreamSupplier source, int bufferSize, int buffers, Executor readExecutor) throws IOException {
        this.maxBuffers = Math.max(buffers, 32768 / bufferSize);
        CompletableFuture initialWait = new CompletableFuture();
        this.waitFuture = CompletableFuture.completedFuture(null);
        this.readFuture = CompletableFuture.runAsync(() -> {
            try (InputStream stream = source.get();){
                while (!this.closed) {
                    int byteCount;
                    int read;
                    byte[] buffer = new byte[bufferSize];
                    for (byteCount = 0; !this.closed && byteCount < buffer.length && (read = stream.read(buffer, byteCount, buffer.length - byteCount)) != -1; byteCount += read) {
                    }
                    if (!this.closed && byteCount > 0) {
                        if (byteCount < buffer.length) {
                            byte[] newBuffer = new byte[byteCount];
                            System.arraycopy(buffer, 0, newBuffer, 0, newBuffer.length);
                            this.appendBuffer(newBuffer);
                        } else {
                            this.appendBuffer(buffer);
                        }
                    }
                    if (initialWait.isDone() || !this.closed && this.readBytes.size() < buffers) continue;
                    initialWait.complete(null);
                }
            }
            catch (IOException e) {
                if (!initialWait.isDone()) {
                    initialWait.completeExceptionally(e);
                }
                throw new CompletionException(e);
            }
        }, readExecutor);
        try {
            initialWait.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    private void appendBuffer(byte[] data) {
        if (this.closed) {
            return;
        }
        this.waitFuture.join();
        if (this.closed) {
            return;
        }
        try {
            this.lock.lock();
            this.readBytes.add(data);
            if (this.readBytes.size() >= this.maxBuffers) {
                this.waitFuture = new CompletableFuture();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean nextBuffer() {
        try {
            this.lock.lock();
            this.pointer = 0;
            if (!this.waitFuture.isDone() && this.readBytes.size() < this.maxBuffers) {
                this.waitFuture.complete(null);
            }
            if (this.readBytes.isEmpty()) {
                this.currentData = null;
                boolean bl = true;
                return bl;
            }
            this.currentData = this.readBytes.remove(0);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rethrowException() throws IOException {
        if (this.readFuture.isCompletedExceptionally()) {
            try {
                this.readFuture.join();
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.rethrowException();
        if ((this.currentData == null || this.pointer >= this.currentData.length) && this.nextBuffer()) {
            return -1;
        }
        return this.currentData[this.pointer++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.rethrowException();
        if ((this.currentData == null || this.pointer >= this.currentData.length) && this.nextBuffer()) {
            return -1;
        }
        int readCount = 0;
        while (readCount < len) {
            if ((this.currentData == null || this.pointer >= this.currentData.length) && this.nextBuffer()) {
                return readCount;
            }
            int readSize = Math.min(this.currentData.length - this.pointer, len - readCount);
            System.arraycopy(this.currentData, this.pointer, b, off, readSize);
            readCount += readSize;
            this.pointer += readSize;
        }
        return readCount;
    }

    @Override
    public long skip(long n) {
        long result;
        long readSize;
        if ((this.currentData == null || this.pointer >= this.currentData.length) && this.nextBuffer()) {
            return 0L;
        }
        for (result = 0L; result < n; result += readSize) {
            if ((this.currentData == null || this.pointer >= this.currentData.length) && this.nextBuffer()) {
                return result;
            }
            readSize = Math.min((long)(this.currentData.length - this.pointer), n - result);
            this.pointer = (int)((long)this.pointer + readSize);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.waitFuture.complete(null);
        this.readFuture.join();
    }

    @FunctionalInterface
    public static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

