/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.api.broom;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.entity.item.EntityBroom;

public class BroomModifier {
    private final ResourceLocation id;
    private final Type type;
    private final float defaultValue;
    private final float tierValue;
    private final int maxTiers;
    private final boolean baseModifier;
    private final List<TextFormatting> tooltipFormats;
    private final int modelColor;
    private final int bakedQuadModelColor;
    private final List<ITickListener> tickListeners = Lists.newLinkedList();
    private final List<ICollisionListener> collisionListeners = Lists.newLinkedList();

    public BroomModifier(ResourceLocation id, Type type, float defaultValue, float tierValue, int maxTiers, boolean baseModifier, List<TextFormatting> tooltipFormats, int modelColor) {
        this.id = id;
        this.type = type;
        this.defaultValue = defaultValue;
        this.tierValue = tierValue;
        this.maxTiers = maxTiers;
        this.baseModifier = baseModifier;
        this.tooltipFormats = tooltipFormats;
        this.modelColor = modelColor;
        this.bakedQuadModelColor = BroomModifier.prepareColor(modelColor, baseModifier);
        if (this.isBaseModifier()) {
            this.tooltipFormats.add(TextFormatting.ITALIC);
        }
    }

    public BroomModifier(ResourceLocation id, Type type, float defaultValue, float tierValue, int maxTiers, boolean baseModifier, TextFormatting singleFormat, int modelColor) {
        this(id, type, defaultValue, tierValue, maxTiers, baseModifier, Lists.newArrayList((Object[])new TextFormatting[]{singleFormat}), modelColor);
    }

    protected static int prepareColor(int modelColor, boolean baseModifier) {
        return Helpers.rgbToBgra((int)modelColor, (int)(baseModifier ? 255 : 200));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.id.func_110623_a();
    }

    public Type getType() {
        return this.type;
    }

    public float apply(float baseValue, List<Float> values) {
        float value = baseValue;
        for (Float v : values) {
            value = ((Float)this.getType().applyer.apply((Object)Pair.of((Object)Float.valueOf(value), (Object)v))).floatValue();
        }
        return value;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getTierValue() {
        return this.tierValue;
    }

    public int getMaxTiers() {
        return this.maxTiers;
    }

    public float getMaxTierValue() {
        return this.getTierValue() * (float)this.getMaxTiers();
    }

    public String getTranslationKey() {
        return "broom.modifiers." + this.id.func_110624_b() + ".type." + this.getName();
    }

    public boolean showTooltip() {
        return this != BroomModifiers.MODIFIER_COUNT;
    }

    public ITextComponent getTooltipLine(String prefix, float value, float bonusValue) {
        return this.getTooltipLine(prefix, value, bonusValue, true);
    }

    public ITextComponent getTooltipLine(String prefix, float value, float bonusValue, boolean showMaxValue) {
        IFormattableTextComponent suffix = new TranslationTextComponent(this.getTranslationKey()).func_240702_b_(": " + value);
        if (bonusValue > 0.0f) {
            suffix = suffix.func_240702_b_(String.format(" (+%s)", Float.valueOf(bonusValue)));
        }
        if (showMaxValue) {
            suffix = suffix.func_240702_b_(String.format(" / %s", Float.valueOf(this.getMaxTierValue())));
        }
        IFormattableTextComponent ret = new StringTextComponent(prefix).func_230529_a_((ITextComponent)suffix);
        for (TextFormatting format : this.getTooltipFormats()) {
            ret = ret.func_240699_a_(format);
        }
        return ret;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isBaseModifier() {
        return this.baseModifier;
    }

    public List<TextFormatting> getTooltipFormats() {
        return this.tooltipFormats;
    }

    public int getModelColor() {
        return this.modelColor;
    }

    public int getBakedQuadModelColor() {
        return this.bakedQuadModelColor;
    }

    public void addTickListener(ITickListener listener) {
        this.tickListeners.add(listener);
    }

    public void addCollisionListener(ICollisionListener listener) {
        this.collisionListeners.add(listener);
    }

    public List<ITickListener> getTickListeners() {
        return Collections.unmodifiableList(this.tickListeners);
    }

    public List<ICollisionListener> getCollisionListeners() {
        return Collections.unmodifiableList(this.collisionListeners);
    }

    public static int getTier(BroomModifier modifier, float value) {
        return (int)Math.ceil(value / modifier.getTierValue());
    }

    public static Triple<Float, Float, Float> getAverageColor(Map<BroomModifier, Float> modifiers) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
            BroomModifier modifier = entry.getKey();
            Triple color = Helpers.intToRGB((int)modifier.getModelColor());
            float factor = entry.getValue().floatValue() / modifier.getMaxTierValue();
            r += ((Float)color.getLeft()).floatValue() * factor;
            g += ((Float)color.getMiddle()).floatValue() * factor;
            b += ((Float)color.getRight()).floatValue() * factor;
            count += factor;
        }
        return Triple.of((Object)Float.valueOf(r / count), (Object)Float.valueOf(g / count), (Object)Float.valueOf(b / count));
    }

    public static interface ICollisionListener {
        public void onCollide(EntityBroom var1, Entity var2, float var3);
    }

    public static interface ITickListener {
        public void onTick(EntityBroom var1, float var2);
    }

    public static enum Type {
        ADDITIVE(new Function<Pair<Float, Float>, Float>(){

            @Nullable
            public Float apply(Pair<Float, Float> input) {
                return Float.valueOf(((Float)input.getLeft()).floatValue() + ((Float)input.getRight()).floatValue());
            }
        }),
        MULTIPLICATIVE(new Function<Pair<Float, Float>, Float>(){

            @Nullable
            public Float apply(@Nullable Pair<Float, Float> input) {
                return Float.valueOf(((Float)input.getLeft()).floatValue() * ((Float)input.getRight()).floatValue());
            }
        });

        private final Function<Pair<Float, Float>, Float> applyer;

        private Type(Function<Pair<Float, Float>, Float> applyer) {
            this.applyer = applyer;
        }

        public Function<Pair<Float, Float>, Float> getApplyer() {
            return this.applyer;
        }
    }
}

