/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.client.particle.ParticleBloodBubble;
import org.cyclops.evilcraft.core.block.BlockTileGuiTank;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;

public class BlockBloodInfuser
extends BlockTileGuiTank {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ON = BooleanProperty.func_177716_a((String)"on");

    public BlockBloodInfuser(AbstractBlock.Properties properties) {
        super(properties, TileBloodInfuser::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ON});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        ParticleBloodBubble.randomDisplayTick((TileWorking)worldIn.func_175625_s(pos), worldIn, pos, rand, (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)stateIn, (Property)FACING, (Comparable)Direction.NORTH));
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileBloodInfuser.class).map(tile -> tile.isVisuallyWorking() ? 4 : super.getLightValue(state, world, pos)).orElse(0);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileBloodInfuser.class).ifPresent(tile -> {
            EntityHelpers.spawnXpAtPlayer((World)player.field_70170_p, (PlayerEntity)player, (int)((int)Math.floor(tile.getXp())));
            tile.resetXp();
        });
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

