/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.block.BlockBloodStainConfig;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.tileentity.TileBloodStain;

public class BlockBloodStain
extends BlockTile {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockBloodStain(AbstractBlock.Properties properties) {
        super(properties, TileBloodStain::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && !state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_217377_a(pos, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        BlockBloodStain.splash(worldIn, pos);
        super.func_196270_a(state, worldIn, pos, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.func_213322_ci().func_72433_c() > 0.1) {
            BlockBloodStain.splash(worldIn, pos);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void splash(World world, BlockPos blockPos) {
        if (MinecraftHelpers.isClientSide()) {
            ParticleBloodSplash.spawnParticles(world, blockPos, 1, 1 + world.field_73012_v.nextInt(1));
        }
    }

    public void func_176224_k(World world, BlockPos blockPos) {
        world.func_217377_a(blockPos, false);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.getSource() == DamageSource.field_76379_h && !(event.getEntity() instanceof EntityVengeanceSpirit)) {
            int x = MathHelper.func_76128_c((double)event.getEntity().func_226277_ct_());
            int y = MathHelper.func_76128_c((double)event.getEntity().func_226278_cu_());
            int z = MathHelper.func_76128_c((double)event.getEntity().func_226281_cx_());
            if (!event.getEntity().field_70170_p.func_201670_d()) {
                event.getEntity().func_184102_h().execute(() -> {
                    BlockPos pos = new BlockPos(x, y - 1, z);
                    Block block = event.getEntity().field_70170_p.func_180495_p(pos).func_177230_c();
                    int amount = (int)((float)BlockBloodStainConfig.bloodMBPerHP * event.getEntityLiving().func_110138_aP());
                    if (block != this) {
                        pos = pos.func_177982_a(0, 1, 0);
                        if (event.getEntity().func_130014_f_().func_175623_d(pos) && this.func_196260_a(this.func_176223_P(), (IWorldReader)event.getEntity().func_130014_f_(), pos)) {
                            event.getEntity().func_130014_f_().func_175656_a(pos, this.func_176223_P());
                        }
                    }
                    TileHelpers.getSafeTile((IBlockReader)event.getEntity().func_130014_f_(), (BlockPos)pos, TileBloodStain.class).ifPresent(tile -> tile.addAmount(amount));
                });
            } else {
                Random random = new Random();
                BlockPos pos = new BlockPos(x, y, z);
                ParticleBloodSplash.spawnParticles(event.getEntity().field_70170_p, pos.func_177982_a(0, 1, 0), (int)event.getEntityLiving().func_110138_aP() + random.nextInt(15), 5 + random.nextInt(5));
            }
        }
    }
}

