/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;

public class BlockBoxOfEternalClosure
extends BlockTile
implements IBlockRarityProvider {
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final VoxelShape SHAPE_EW = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.88f, (double)16.0);
    public static final VoxelShape SHAPE_NS = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.88f, (double)12.0);
    public static ItemStack boxOfEternalClosureFilled;

    public BlockBoxOfEternalClosure(AbstractBlock.Properties properties) {
        super(properties, TileBoxOfEternalClosure::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction rotation = (Direction)state.func_177229_b((Property)FACING);
        return rotation == Direction.EAST || rotation == Direction.WEST ? SHAPE_EW : SHAPE_NS;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeWithFallbackSpirit(ItemStack itemStack) {
        if (BlockBoxOfEternalClosure.hasPlayer(itemStack)) {
            return EntityType.field_200725_aD;
        }
        EntityType<?> spiritType = BlockBoxOfEternalClosure.getSpiritTypeRaw(itemStack.func_77978_p());
        if (spiritType == null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("spiritTag")) {
            return RegistryEntries.ENTITY_VENGEANCE_SPIRIT;
        }
        return spiritType;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeRaw(@Nullable CompoundNBT tag) {
        return TileBoxOfEternalClosure.getSpiritType(tag);
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT spiritTag = new CompoundNBT();
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setSwarm(true);
        spiritData.setRandomSwarmTier(new Random());
        spiritData.writeNBT(spiritTag);
        tag.func_218657_a("spiritTag", (INBT)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT spiritTag = new CompoundNBT();
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setPlayerId(playerId.toString());
        spiritData.setPlayerName(FORGOTTEN_PLAYER);
        tag.func_74778_a("playerId", spiritData.getPlayerId());
        tag.func_74778_a("playerName", spiritData.getPlayerName());
        spiritData.writeNBT(spiritTag);
        tag.func_218657_a("spiritTag", (INBT)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public static String getPlayerName(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerName", 8)) {
            return itemStack.func_77978_p().func_74779_i("playerName");
        }
        return "";
    }

    public static String getPlayerId(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerId", 8)) {
            return itemStack.func_77978_p().func_74779_i("playerId");
        }
        return "";
    }

    public static boolean hasPlayer(ItemStack itemStack) {
        return !BlockBoxOfEternalClosure.getPlayerId(itemStack).isEmpty();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((IWorldReader)worldIn, (BlockPos)pos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult blockRayTraceResult) {
        return TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)pos, TileBoxOfEternalClosure.class).map(tile -> {
            if (tile.isClosed()) {
                tile.open();
                return ActionResultType.SUCCESS;
            }
            return super.func_225533_a_(state, worldIn, pos, player, handIn, blockRayTraceResult);
        }).orElseGet(() -> super.func_225533_a_(state, worldIn, pos, player, handIn, blockRayTraceResult));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileBoxOfEternalClosure.class).map(tile -> tile.getLidAngle() > 0.0f ? 6 : super.getLightValue(state, world, pos)).orElse(0);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)this));
        items.add((Object)boxOfEternalClosureFilled);
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return BlockBoxOfEternalClosure.hasPlayer(itemStack) ? Rarity.RARE : Rarity.UNCOMMON;
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).hasSpirit()) {
            return 15;
        }
        return super.func_180641_l(blockState, world, blockPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState blockState, World world, RayTraceResult target, ParticleManager particleManager) {
        if (target != null) {
            RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (ClientWorld)((ClientWorld)world), (BlockState)Blocks.field_150343_Z.func_176223_P(), (BlockPos)((BlockRayTraceResult)target).func_216350_a(), (Direction)((BlockRayTraceResult)target).func_216354_b());
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager particleManager) {
        RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (ClientWorld)((ClientWorld)world), (BlockState)Blocks.field_150343_Z.func_176223_P(), (BlockPos)pos, (Direction)Direction.UP);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addLandingEffects(BlockState blockState, ServerWorld world, BlockPos blockPosition, BlockState iblockstate, LivingEntity entity, int numberOfParticles) {
        return true;
    }
}

