/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.core.block.BlockTileGuiTank;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;

public class BlockColossalBloodChest
extends BlockTileGuiTank
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public BlockColossalBloodChest(AbstractBlock.Properties properties) {
        super(properties, TileColossalBloodChest::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? BlockRenderType.ENTITYBLOCK_ANIMATED : super.func_149645_b(blockState);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            if (!TileColossalBloodChest.canWork(world, blockPos)) {
                return ActionResultType.FAIL;
            }
            return super.func_225533_a_(blockState, world, blockPos, player, hand, rayTraceResult);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player, hand);
        return ActionResultType.FAIL;
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    public static void triggerDetector(IWorldReader world, BlockPos blockPos, boolean valid) {
        TileColossalBloodChest.getCubeDetector().detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileColossalBloodChest tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = (TileColossalBloodChest)TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileColossalBloodChest.class).orElse(null)) != null) {
            tile.setSize(Vector3i.field_177959_e);
        }
        BlockColossalBloodChest.triggerDetector((IWorldReader)world, pos, true);
    }

    public void func_220082_b(BlockState blockStateNew, World world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.func_220082_b(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.func_177230_c() != blockStateOld.func_177230_c() && !((Boolean)blockStateNew.func_177229_b((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, blockPos, true);
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.func_177229_b((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, blockPos, false);
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, pos, false);
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.getBlock().func_180652_a(world, pos, explosion);
    }

    public void onDetect(IWorldReader world, BlockPos location, Vector3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            ((World)world).func_180501_a(location, (BlockState)world.func_180495_p(location).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)location, TileColossalBloodChest.class).ifPresent(tile -> {
                tile.setSize(valid ? size : Vector3i.field_177959_e);
                tile.setCenter(originCorner.func_177982_a(1, 1, 1));
            });
        }
    }

    public static void addPlayerChatError(World world, BlockPos blockPos, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_190926_b()) {
            DetectionResult result = TileColossalBloodChest.getCubeDetector().detect((IWorldReader)world, blockPos, null, false);
            if (result != null && result.getError() != null) {
                BlockColossalBloodChest.addPlayerChatError(player, result.getError());
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("multiblock.evilcraft.colossalbloodchest.error.unexpected"), Util.field_240973_b_);
            }
        }
    }

    public static void addPlayerChatError(PlayerEntity player, ITextComponent error) {
        StringTextComponent chat = new StringTextComponent("");
        IFormattableTextComponent prefix = new StringTextComponent("[").func_230529_a_((ITextComponent)new TranslationTextComponent("multiblock.evilcraft.colossalbloodchest.error.prefix")).func_230529_a_((ITextComponent)new StringTextComponent("]: ")).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("multiblock.evilcraft.colossalbloodchest.error.prefix.info"))));
        chat.func_230529_a_((ITextComponent)prefix);
        chat.func_230529_a_(error);
        player.func_145747_a((ITextComponent)chat, Util.field_240973_b_);
    }
}

