/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.block.BlockDarkOreConfig;

public class BlockDarkOre
extends Block
implements IInformationProvider {
    private static final int INCREASE_XP = 5;
    public static final BooleanProperty GLOWING = BooleanProperty.func_177716_a((String)"glowing");

    public BlockDarkOre(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)GLOWING, (Comparable)Boolean.valueOf(false));
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? 1 + this.RANDOM.nextInt(5) : 0;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.glow(worldIn, pos);
        super.func_196270_a(state, worldIn, pos, player);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        this.glow(world, pos);
        super.func_176199_a(world, pos, entity);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        this.glow(worldIn, pos);
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    private boolean isGlowing(World world, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)world.func_180495_p(blockPos), (Property)GLOWING, (Comparable)Boolean.valueOf(true));
    }

    private void glow(World world, BlockPos blockPos) {
        if (world.func_201670_d()) {
            this.sparkle(world, blockPos);
        }
        if (!this.isGlowing(world, blockPos)) {
            world.func_180501_a(blockPos, (BlockState)this.func_176223_P().func_206870_a((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)GLOWING);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos blockPos, Random rand) {
        if (this.isGlowing((World)world, blockPos)) {
            world.func_180501_a(blockPos, (BlockState)this.func_176223_P().func_206870_a((Property)GLOWING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos blockPos, Random rand) {
        if (this.isGlowing(world, blockPos)) {
            this.sparkle(world, blockPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void sparkle(World world, BlockPos blockPos) {
        Random random = world.field_73012_v;
        double offset = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double sparkX = (float)blockPos.func_177958_n() + random.nextFloat();
            double sparkY = (float)blockPos.func_177956_o() + random.nextFloat();
            double sparkZ = (float)blockPos.func_177952_p() + random.nextFloat();
            if (l == 0 && !world.func_180495_p(blockPos.func_177982_a(0, 1, 0)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(0, 1, 0))) {
                sparkY = (double)(blockPos.func_177956_o() + 1) + offset;
            }
            if (l == 1 && !world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(0, -1, 0))) {
                sparkY = (double)blockPos.func_177956_o() - offset;
            }
            if (l == 2 && !world.func_180495_p(blockPos.func_177982_a(0, 0, 1)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(0, 0, 1))) {
                sparkZ = (double)(blockPos.func_177952_p() + 1) + offset;
            }
            if (l == 3 && !world.func_180495_p(blockPos.func_177982_a(0, 0, -1)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(0, 0, -1))) {
                sparkZ = (double)blockPos.func_177952_p() - offset;
            }
            if (l == 4 && !world.func_180495_p(blockPos.func_177982_a(1, 0, 0)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(1, 0, 0))) {
                sparkX = (double)(blockPos.func_177958_n() + 1) + offset;
            }
            if (l == 5 && !world.func_180495_p(blockPos.func_177982_a(-1, 0, 0)).func_215686_e((IBlockReader)world, blockPos.func_177982_a(-1, 0, 0))) {
                sparkX = (double)blockPos.func_177958_n() - offset;
            }
            if (!(sparkX < (double)blockPos.func_177958_n() || sparkX > (double)(blockPos.func_177958_n() + 1) || sparkY < 0.0 || sparkY > (double)(blockPos.func_177956_o() + 1) || sparkZ < (double)blockPos.func_177952_p()) && !(sparkZ > (double)(blockPos.func_177952_p() + 1))) continue;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, sparkX, sparkY, sparkZ, 0.0, 0.0, 0.0);
        }
    }

    public IFormattableTextComponent getInfo(ItemStack itemStack) {
        return new TranslationTextComponent(this.func_149739_a() + ".info.custom", new Object[]{BlockDarkOreConfig.endY}).func_240701_a_(INFO_PREFIX_STYLES);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
    }
}

