/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class BlockDarkTank
extends BlockTile
implements IBlockTank {
    public static final String NBT_KEY_DRAINING = "enabled";
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final ModelProperty<Integer> TANK_CAPACITY = new ModelProperty();
    public static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.016f, (double)2.0, (double)14.0, (double)15.984f, (double)14.0);

    public BlockDarkTank(AbstractBlock.Properties properties) {
        super(properties, TileDarkTank::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)Direction.UP)) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)pos, TileDarkTank.class).ifPresent(tile -> {
                tile.setEnabled(!tile.isEnabled());
                player.func_146105_b((ITextComponent)new StringTextComponent(String.format("%,d", tile.getTank().getFluidAmount())).func_240702_b_(" / ").func_240702_b_(String.format("%,d", tile.getTank().getCapacity())).func_240702_b_(" mB"), true);
            });
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileDarkTank.class).map(tile -> tile.getTank().getFluidType() != null ? (int)Math.min(15.0, tile.getFillRatio() * (double)tile.getTank().getFluidType().getAttributes().getLuminosity(tile.getTank().getFluid()) * 15.0) : 0).orElse(0);
    }

    @Override
    public int getDefaultCapacity() {
        return 16000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, PlayerEntity player) {
        if (player.func_213453_ef()) {
            if (!world.func_201670_d()) {
                ItemStack activated = itemStack.func_77946_l();
                if (this.isActivated(itemStack, world)) {
                    activated.func_196082_o().func_82580_o(NBT_KEY_DRAINING);
                    if (activated.func_77978_p().isEmpty()) {
                        activated.func_77982_d(null);
                    }
                } else {
                    activated.func_196082_o().func_74757_a(NBT_KEY_DRAINING, !this.isActivated(itemStack, world));
                }
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n(NBT_KEY_DRAINING);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        int capacity = capacityOriginal = 16000;
        do {
            IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack.func_77946_l()).orElse(null);
            fluidHandler.setCapacity(capacity);
            list.add((Object)fluidHandler.getContainer().func_77946_l());
            fluidHandler.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, capacity), IFluidHandler.FluidAction.EXECUTE);
            list.add((Object)fluidHandler.getContainer().func_77946_l());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(BlockDarkTankConfig.maxTankCreativeSize, BlockDarkTankConfig.maxTankSize) && capacity > lastCapacity);
        if (BlockDarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                if (fluid == RegistryEntries.FLUID_BLOOD) continue;
                try {
                    ItemStack itemStackFilled = itemStack.func_77946_l();
                    IFluidHandlerItemCapacity fluidHandlerFilled = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStackFilled).orElse(null);
                    fluidHandlerFilled.setCapacity(capacityOriginal);
                    fluidHandlerFilled.fill(new FluidStack(fluid, capacityOriginal), IFluidHandler.FluidAction.EXECUTE);
                    list.add((Object)fluidHandlerFilled.getContainer());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }
}

