/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.tileentity.TileDisplayStand;

public class BlockDisplayStand
extends BlockTile {
    private static final String NBT_TYPE = "displayStandType";
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty AXIS_X = BooleanProperty.func_177716_a((String)"axis_x");
    public static final ModelProperty<Direction.AxisDirection> DIRECTION = new ModelProperty();
    public static final ModelProperty<ItemStack> TYPE = new ModelProperty();
    public static final Map<Direction, VoxelShape> FACING_BOUNDS = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)).put((Object)Direction.UP, (Object)Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).put((Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0)).put((Object)Direction.EAST, (Object)Block.func_208617_a((double)8.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)).put((Object)Direction.NORTH, (Object)Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)8.0)).put((Object)Direction.SOUTH, (Object)Block.func_208617_a((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)16.0)).build();

    public BlockDisplayStand(AbstractBlock.Properties properties) {
        super(properties, TileDisplayStand::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, AXIS_X});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return FACING_BOUNDS.get(BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)FACING, (Comparable)Direction.DOWN));
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDisplayStand.class).map(tile -> !tile.getInventory().func_70301_a(0).func_190926_b() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = super.func_196258_a(context);
        blockState = (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d());
        Direction playerFacing = context.func_195999_j().func_174811_aO();
        boolean axisX = context.func_196000_l().func_176734_d() == Direction.DOWN || context.func_196000_l().func_176734_d() == Direction.UP ? playerFacing.func_176740_k() == Direction.Axis.X : playerFacing.func_176740_k() != Direction.Axis.X && playerFacing.func_176740_k() != Direction.Axis.Z;
        blockState = (BlockState)blockState.func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(axisX));
        return blockState;
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, blockPos, blockState, entity, stack);
        if (!world.func_201670_d()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDisplayStand.class).ifPresent(tile -> {
                tile.setDisplayStandType(this.getDisplayStandType(stack));
                tile.setDirection(entity.func_174811_aO().func_176743_c());
            });
        }
    }

    public BlockState rotate(BlockState blockState, IWorld world, BlockPos pos, Rotation direction) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileDisplayStand.class).map(tile -> {
            if (tile.getDirection() == Direction.AxisDirection.POSITIVE) {
                if (((Boolean)blockState.func_177229_b((Property)AXIS_X)).booleanValue()) {
                    tile.setDirection(Direction.AxisDirection.POSITIVE);
                    return (BlockState)blockState.func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
                }
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)blockState.func_177229_b((Property)AXIS_X)).booleanValue()) {
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
            }
            tile.setDirection(Direction.AxisDirection.POSITIVE);
            return (BlockState)blockState.func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
        }).orElse(blockState);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> list) {
        try {
            for (Item item : ItemTags.field_199905_b.func_230236_b_()) {
                if (!(item instanceof BlockItem)) continue;
                BlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)new ItemStack((IItemProvider)item));
                list.add((Object)this.getTypedDisplayStandItem(plankWoodBlockState));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public ItemStack getTypedDisplayStandItem(BlockState blockState) {
        CompoundNBT blockTag = BlockHelpers.serializeBlockState((BlockState)blockState);
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_218657_a(NBT_TYPE, (INBT)blockTag);
        return itemStack;
    }

    public ItemStack getDisplayStandType(ItemStack displayStandStack) {
        CompoundNBT tag = displayStandStack.func_77978_p();
        if (tag != null && tag.func_74764_b(NBT_TYPE)) {
            BlockState blockState = BlockHelpers.deserializeBlockState((CompoundNBT)tag.func_74775_l(NBT_TYPE));
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public static void setDisplayStandType(ItemStack displayStandStack, ItemStack type) {
        CompoundNBT tag = displayStandStack.func_196082_o();
        tag.func_218657_a(NBT_TYPE, (INBT)BlockHelpers.serializeBlockState((BlockState)BlockHelpers.getBlockStateFromItemStack((ItemStack)type)));
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == this) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        TileDisplayStand tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileDisplayStand.class).orElse(null);
        if (tile != null) {
            ItemStack tileStack = tile.getInventory().func_70301_a(0);
            if ((itemStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)tileStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)tileStack) && tileStack.func_190916_E() < tileStack.func_77976_d()) && !tileStack.func_190926_b()) {
                if (!itemStack.func_190926_b()) {
                    tileStack.func_190917_f(itemStack.func_190916_E());
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                tile.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
            if (!itemStack.func_190926_b() && tile.getInventory().func_70301_a(0).func_190926_b()) {
                tile.getInventory().func_70299_a(0, itemStack.func_77979_a(1));
                if (itemStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        ItemStack blockType = this.getDisplayStandType(stack);
        if (blockType != null) {
            tooltip.add((ITextComponent)((IFormattableTextComponent)blockType.func_200301_q()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((IWorldReader)worldIn, (BlockPos)pos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!world.func_201670_d() && oldState.func_177230_c() != newState.func_177230_c()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDisplayStand.class).ifPresent(tile -> InventoryHelpers.dropItems((World)world, (IInventory)tile.getInventory(), (BlockPos)blockPos));
        }
        super.func_196243_a(oldState, world, blockPos, newState, isMoving);
    }
}

