/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.item.ItemEntangledChalice;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class BlockEntangledChalice
extends BlockTile
implements IInformationProvider,
IBlockTank,
IBlockRarityProvider {
    public static final BooleanProperty DRAINING = BooleanProperty.func_177716_a((String)"draining");
    public static final ModelProperty<String> TANK_ID = new ModelProperty();
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BlockEntangledChalice(AbstractBlock.Properties properties) {
        super(properties, TileEntangledChalice::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DRAINING, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DRAINING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DRAINING, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)blockPos, (Direction)Direction.UP)) {
            return ActionResultType.SUCCESS;
        }
        if (world.func_201670_d()) {
            String tankId = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileEntangledChalice.class).map(TileEntangledChalice::getWorldTankId).orElse("null");
            player.func_146105_b((ITextComponent)new TranslationTextComponent(L10NHelpers.localize((String)"block.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)})), true);
        }
        return super.func_225533_a_(state, world, blockPos, player, hand, rayTraceResult);
    }

    public IFormattableTextComponent getInfo(ItemStack itemStack) {
        return BlockTankHelpers.getInfoTank(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
    }

    @Override
    public int getDefaultCapacity() {
        return 4000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, PlayerEntity player) {
        if (player.func_213453_ef()) {
            if (!world.func_201670_d()) {
                ItemStack activated = itemStack.func_77946_l();
                if (this.isActivated(itemStack, world)) {
                    activated.func_196082_o().func_82580_o("enabled");
                    if (activated.func_77978_p().isEmpty()) {
                        activated.func_77982_d(null);
                    }
                } else {
                    activated.func_196082_o().func_74757_a("enabled", !this.isActivated(itemStack, world));
                }
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world) {
        return ItemHelpers.isActivated(itemStack);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos blockPos) {
        TileEntangledChalice tank;
        Fluid fluidType;
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile != null && tile instanceof TileEntangledChalice && (fluidType = (tank = (TileEntangledChalice)tile).getTank().getFluidType()) != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)fluidType.getAttributes().getLuminosity());
        }
        return 0;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            ItemEntangledChalice.FluidHandler fluidHandler = (ItemEntangledChalice.FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
            fluidHandler.setTankID("creative");
            list.add((Object)itemStack);
        }
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return Rarity.RARE;
    }
}

