/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimed;
import org.cyclops.evilcraft.entity.item.EntityLightningGrenade;

public class BlockLightningBomb
extends Block {
    public static final BooleanProperty PRIMED = BooleanProperty.func_177716_a((String)"primed");

    public BlockLightningBomb(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PRIMED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(false));
    }

    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(blockState, world, blockPos, oldState, isMoving);
        if (world.func_175640_z(blockPos)) {
            this.func_176206_d((IWorld)world, blockPos, (BlockState)blockState.func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.func_217377_a(blockPos, false);
        }
    }

    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(blockState, world, blockPos, blockIn, fromPos, isMoving);
        if (world.func_175640_z(blockPos)) {
            this.func_176206_d((IWorld)world, blockPos, (BlockState)blockState.func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.func_217377_a(blockPos, false);
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos blockPos, Explosion explosion) {
        if (!world.func_201670_d()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed(world, (float)blockPos.func_177958_n() + 0.5f, (float)blockPos.func_177956_o() + 0.5f, (float)blockPos.func_177952_p() + 0.5f, explosion.func_94613_c());
            entityprimed.func_184534_a(world.field_73012_v.nextInt(entityprimed.func_184536_l() / 4) + entityprimed.func_184536_l() / 8);
            world.func_217376_c((Entity)entityprimed);
            world.func_217377_a(blockPos, false);
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        super.func_176206_d(world, blockPos, blockState);
        this.primeBomb(world, blockPos, blockState, null);
    }

    public void primeBomb(IWorld world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity placer) {
        if (!world.func_201670_d() && ((Boolean)blockState.func_177229_b((Property)PRIMED)).booleanValue()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed((World)world, (float)blockPos.func_177958_n() + 0.5f, (float)blockPos.func_177956_o() + 0.5f, (float)blockPos.func_177952_p() + 0.5f, placer);
            world.func_217376_c((Entity)entityprimed);
            world.func_184133_a(null, blockPos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (!(player.func_184586_b(hand).func_190926_b() || player.func_184586_b(hand).func_77973_b() != Items.field_151033_d && player.func_184586_b(hand).func_77973_b() != Items.field_151059_bz)) {
            this.primeBomb((IWorld)world, blockPos, (BlockState)this.func_176223_P().func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(true)), (LivingEntity)player);
            world.func_217377_a(blockPos, false);
            player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, e -> {});
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, blockPos, player, hand, p_225533_6_);
    }

    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
        BlockState primedState = (BlockState)this.func_176223_P().func_206870_a((Property)PRIMED, (Comparable)Boolean.valueOf(true));
        if (entity instanceof AbstractArrowEntity && !world.func_201670_d()) {
            AbstractArrowEntity entityarrow = (AbstractArrowEntity)entity;
            if (entityarrow.func_70027_ad()) {
                this.primeBomb((IWorld)world, blockPos, primedState, entityarrow.func_234616_v_() instanceof LivingEntity ? (LivingEntity)entityarrow.func_234616_v_() : null);
                world.func_217377_a(blockPos, false);
            }
        } else if (entity instanceof EntityLightningGrenade && !world.func_201670_d()) {
            EntityLightningGrenade entitygrenade = (EntityLightningGrenade)entity;
            this.primeBomb((IWorld)world, blockPos, primedState, entitygrenade.func_234616_v_() instanceof LivingEntity ? (LivingEntity)entitygrenade.func_234616_v_() : null);
            world.func_217377_a(blockPos, false);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }
}

