/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.tileentity.TilePurifier;

public class BlockPurifier
extends BlockTile
implements IBlockTank {
    private static final VoxelShape INSIDE = BlockPurifier.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)BlockPurifier.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockPurifier.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockPurifier.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public BlockPurifier(AbstractBlock.Properties properties) {
        super(properties, TilePurifier::new);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        TilePurifier tile = (TilePurifier)world.func_175625_s(blockPos);
        if (tile != null) {
            if (itemStack.func_190926_b() && !tile.getPurifyItem().func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tile.getPurifyItem());
                tile.setPurifyItem(ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (itemStack.func_190926_b() && !tile.getAdditionalItem().func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tile.getAdditionalItem());
                tile.setAdditionalItem(ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)blockPos, (Direction)Direction.UP)) {
                return ActionResultType.SUCCESS;
            }
            if (!itemStack.func_190926_b() && tile.getActions().isItemValidForAdditionalSlot(itemStack) && tile.getAdditionalItem().func_190926_b()) {
                ItemStack copy = itemStack.func_77946_l();
                copy.func_190920_e(1);
                tile.setAdditionalItem(copy);
                itemStack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (!itemStack.func_190926_b() && tile.getActions().isItemValidForMainSlot(itemStack) && tile.getPurifyItem().func_190926_b()) {
                ItemStack copy = itemStack.func_77946_l();
                copy.func_190920_e(1);
                tile.setPurifyItem(copy);
                itemStack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return INSIDE;
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        TilePurifier tile = (TilePurifier)world.func_175625_s(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!world.func_201670_d() && oldState.func_177230_c() != newState.func_177230_c()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TilePurifier.class).ifPresent(tile -> InventoryHelpers.dropItems((World)world, (IInventory)tile.getInventory(), (BlockPos)blockPos));
        }
        super.func_196243_a(oldState, world, blockPos, newState, isMoving);
    }

    @Override
    public int getDefaultCapacity() {
        return 3000;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, PlayerEntity player) {
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world) {
        return false;
    }
}

