/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BlockColossalBloodChest;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;

public class BlockReinforcedUndeadPlank
extends Block
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public BlockReinforcedUndeadPlank(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? BlockRenderType.ENTITYBLOCK_ANIMATED : super.func_149645_b(blockState);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.captureBlockSnapshots) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, pos, true);
        }
    }

    public void func_220082_b(BlockState blockStateNew, World world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.func_220082_b(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.func_177230_c() != blockStateOld.func_177230_c() && !((Boolean)blockStateNew.func_177229_b((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, blockPos, true);
        }
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((IWorldReader)world, pos, false);
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.getBlock().func_180652_a(world, pos, explosion);
    }

    public void onDetect(IWorldReader world, BlockPos location, Vector3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)world.func_180495_p(location), (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) == false;
            ((World)world).func_180501_a(location, (BlockState)world.func_180495_p(location).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                TileColossalBloodChest.detectStructure((World)world, location, size, valid, originCorner);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            final Wrapper tileLocationWrapper = new Wrapper();
            TileColossalBloodChest.getCubeDetector().detect((IWorldReader)world, blockPos, null, new CubeDetector.IValidationAction(){

                public ITextComponent onValidate(BlockPos location, BlockState blockState) {
                    if (blockState.func_177230_c() instanceof BlockColossalBloodChest) {
                        tileLocationWrapper.set(location);
                    }
                    return null;
                }
            }, false);
            BlockPos tileLocation = (BlockPos)tileLocationWrapper.get();
            if (tileLocation != null) {
                return world.func_180495_p(tileLocation).func_177230_c().func_225533_a_(world.func_180495_p(tileLocation), world, tileLocation, player, hand, p_225533_6_);
            }
            return super.func_225533_a_(blockState, world, blockPos, player, hand, p_225533_6_);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player, hand);
        return ActionResultType.FAIL;
    }
}

